/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.security.SecureRandom;
import nxm.sys.lib.Intrinsic;
import nxm.sys.libm.Random;

public class Setseed
extends Intrinsic {
    private static final int MAX_SEED_VALUE = 0x4000000;

    @Override
    public int process() {
        int newseed;
        boolean genseed = this.MA.getState("/GEN", false);
        if (genseed) {
            SecureRandom secureRand = new SecureRandom();
            newseed = secureRand.nextInt(0x4000000);
        } else {
            newseed = this.MA.getL("NEWSEED", -1);
        }
        if (newseed >= 0x4000000) {
            this.M.error("Seed value [" + newseed + "] exceeds 2**26 - 1");
        }
        if (newseed >= 0) {
            Random.setSeed(newseed);
        }
        if (this.verbose) {
            this.M.info("Seed is " + Random.getSeed());
        }
        return 9;
    }
}

