/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.File;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Query
extends Intrinsic {
    public static final String filterList = "Public,Private,Inherited,Interface,FullSig,Docs";
    private static int F_NONE = 0;
    private static int F_PUBLIC = 1;
    private static int F_PRIVATE = 2;
    private static int F_INHERIT = 4;
    private static int F_INTER = 8;
    private static int F_FULLSIG = 16;
    private static int F_DOCS = 32;
    private static int F_ALL = 15;
    private static int F_ACCESS = F_PUBLIC | F_PRIVATE;
    private static int F_INHERIT_INTER = F_INHERIT | F_INTER;
    private static final int DEFAULT_COL_WIDTH = 30;
    private static final int MODIFIER_PUBLIC_PROTECTED = 5;
    private static final String INDENT = "  ";
    private static boolean pureReflectionCodeOnly = true;
    private int constMask;
    private int fieldMask;
    private int methodMask;
    private int numRows;
    private int colWidth;
    private String memberName;
    private String listName;
    private String listValue;
    private String csName;
    private String resName;
    private boolean all;
    private boolean startsWith;
    private boolean exactMatch;
    private boolean resultOnly;
    private boolean userFullSig;

    @Override
    public int process() {
        int defMask;
        this.listValue = null;
        Class<?> clas = null;
        Object object = null;
        boolean jdk7plus = StringUtil.compareVersions("1.7.0", Shell.getJavaVersion()) <= 0;
        this.csName = this.MA.getCS("NAME");
        this.resName = this.MA.getU("NAME");
        this.listName = this.MA.getU("/LIST", null);
        this.memberName = this.MA.getCS("METH");
        this.all = this.MA.getState("/ALL");
        boolean pureReflectionCode = pureReflectionCodeOnly || this.MA.getLength("/PARAMS") >= 0;
        this.resultOnly = this.listName != null;
        int n = defMask = pureReflectionCode && !this.resultOnly ? F_PUBLIC | F_FULLSIG | F_INHERIT : F_PUBLIC | F_INHERIT;
        if (this.all) {
            defMask |= F_PRIVATE | F_INTER;
        }
        defMask = this.MA.getOptionMask("/MASK", filterList, defMask);
        boolean bl = this.userFullSig = (this.MA.getOptionMask("/MASK", filterList, 0) & F_FULLSIG) != 0;
        if (jdk7plus) {
            defMask &= ~F_DOCS;
        }
        this.constMask = this.methodMask = defMask;
        this.fieldMask = this.methodMask;
        if (this.MA.getState("/GETS")) {
            this.memberName = "GET*";
            this.constMask = this.fieldMask = F_NONE;
        }
        if (this.MA.getState("/SETS")) {
            this.memberName = "SET*";
            this.constMask = this.fieldMask = F_NONE;
        }
        if (this.MA.getState("/FIELDS")) {
            this.methodMask = this.constMask = F_NONE;
        }
        this.methodMask = this.MA.getOptionMask("/M", filterList, this.methodMask);
        this.fieldMask = this.MA.getOptionMask("/F", filterList, this.fieldMask);
        this.constMask = this.MA.getOptionMask("/C", filterList, this.constMask);
        this.colWidth = this.MA.getL("/NC", 30);
        this.numRows = this.MA.getL("/NR", this.M.terminal.getRows());
        if (this.MA.find("/NR")) {
            this.M.terminal.setRows(this.numRows);
        }
        if (pureReflectionCode) {
            try {
                this.queryPureReflection();
            }
            catch (Exception e) {
                this.M.warning("New Query via Reflection code Exception, please report " + e);
            }
            return 9;
        }
        if (jdk7plus) {
            this.constMask = this.methodMask = F_ALL;
            this.fieldMask = this.methodMask;
        }
        if (this.MA.getState("/DEBUG")) {
            System.out.println("Query Name=" + this.csName + " matche=" + this.memberName + " MethodMask=" + this.methodMask + " FieldMask=" + this.fieldMask + " all=" + this.all);
        }
        if (this.csName.length() == 0) {
            this.M.error("No object specified");
        } else {
            object = this.MR.get(this.resName);
            if (object != null) {
                clas = object.getClass();
            } else {
                try {
                    clas = Class.forName(this.csName);
                }
                catch (Exception e) {
                    Args targs = Shell.parseCommand(this.M, this.csName);
                    Command command = Shell.loadCommand(this.M, targs);
                    switch (command.support) {
                        case 'P': {
                            clas = command.getClass();
                            object = command;
                            break;
                        }
                        case 'I': {
                            clas = command.getClass();
                            object = command;
                            break;
                        }
                        default: {
                            clas = Query.getClass(this.csName);
                        }
                    }
                }
            }
        }
        if (clas == null) {
            this.M.error("Query Object " + this.csName + " not found");
        } else {
            String fileName = this.getJavaDocsFilename(clas.getName().trim());
            if (fileName == null) {
                fileName = "API location.";
            }
            this.M.info("For best viewing, view API in web browser at " + fileName);
            if (jdk7plus) {
                this.M.warning("Use of QUERY with JDK 7+ has limited functionality.");
            }
        }
        if (this.listName != null) {
            this.doQueryClass(clas, this.memberName);
            this.MR.put(this.listName, (Object)this.listValue);
        } else {
            this.doQuery(clas, object);
        }
        return 9;
    }

    private void queryPureReflection() {
        Object result;
        if (!this.resultOnly) {
            this.M.more(1);
        } else {
            this.listValue = "";
        }
        Class<?> clazz = null;
        if (this.csName.length() == 0) {
            this.M.error("No object specified");
        }
        if ((result = this.MR.get(this.resName)) != null) {
            clazz = result.getClass();
        } else {
            try {
                clazz = Class.forName(this.csName);
            }
            catch (Exception e) {
                Args targs = Shell.parseCommand(this.M, this.csName);
                Command command = Shell.loadCommand(this.M, targs);
                switch (command.support) {
                    case 'P': {
                        clazz = command.getClass();
                        break;
                    }
                    case 'I': {
                        clazz = command.getClass();
                        break;
                    }
                    default: {
                        clazz = Query.getClass(this.csName);
                    }
                }
            }
        }
        if (clazz == null) {
            this.M.error("Query Object " + this.csName + " not found");
        }
        this.setupMatchingRequirements();
        this.processLinkInChain(clazz, result, "ClassName");
        if (!this.resultOnly) {
            this.M.more(9);
        } else {
            if (this.listValue != "") {
                this.listValue = this.listValue.substring(0, this.listValue.length() - 1);
            }
            this.MR.put(this.listName, (Object)this.listValue);
        }
    }

    private void setupMatchingRequirements() {
        int iAsterisk = this.memberName.indexOf(42);
        if (iAsterisk == 0) {
            this.exactMatch = false;
            this.startsWith = false;
        } else if (iAsterisk > 0) {
            this.startsWith = true;
            this.exactMatch = false;
            this.memberName = this.memberName.substring(0, iAsterisk).toLowerCase();
            this.constMask = F_NONE;
        } else if ("<init>".equals(this.memberName.toLowerCase())) {
            this.methodMask = this.fieldMask = F_NONE;
            this.constMask |= F_PUBLIC;
            this.exactMatch = false;
            this.startsWith = false;
        } else {
            this.startsWith = false;
            this.exactMatch = true;
            this.memberName = this.memberName.toLowerCase();
            this.constMask = F_NONE;
        }
    }

    private void processLinkInChain(Class<?> clazz, Object object, String title) {
        Object nextObj = this.nextChainedObject(object);
        if (!this.resultOnly) {
            this.classInheritanceViaReflection(clazz, title);
        }
        if (Keyable.class.isAssignableFrom(clazz) && !this.resultOnly) {
            this.M.more(" *** Class implements Keyable, setKey and getKey may override methods ***");
        }
        if (this.constMask != F_NONE) {
            this.constructorsViaReflection(clazz);
        }
        if (this.methodMask != F_NONE) {
            this.methodsViaReflection(clazz);
        }
        if ((this.methodMask & F_INHERIT_INTER) != 0) {
            this.inheritedMethodsViaReflection(clazz);
        }
        if (this.fieldMask != F_NONE) {
            this.fieldsViaReflection(clazz);
        }
        if ((!this.resultOnly || this.exactMatch) && nextObj != null) {
            if (!this.resultOnly) {
                this.M.more("");
            }
            this.processLinkInChain(nextObj.getClass(), nextObj, "Chained to Class");
        }
    }

    private void classInheritanceViaReflection(Class<?> clazz, String title) {
        String implement = "";
        Object[] interfaceArray = clazz.getInterfaces();
        if (interfaceArray.length != 0) {
            implement = Arrays.toString(interfaceArray).replaceAll("interface ", "");
            implement = " implements " + implement.substring(1, implement.length() - 1);
        }
        String extend = "";
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && Object.class != superClass) {
            extend = " extends " + superClass.toString().replace("class ", "");
        }
        String listing = clazz.toString() + extend + implement;
        if (!this.resultOnly) {
            this.M.more(title + " -> " + listing);
        }
    }

    private void constructorsViaReflection(Class<?> clazz) {
        boolean fullSignature;
        String cnstrHeader = "Constructors - all declared with options " + Parser.mask2s(filterList, this.constMask & F_ACCESS);
        boolean listPublicProtected = (this.constMask & F_PUBLIC) != 0;
        boolean listDefaultPrivate = (this.constMask & F_PRIVATE) != 0;
        Constructor<?>[] cnstrs = clazz.getDeclaredConstructors();
        boolean bl = fullSignature = (this.constMask & F_FULLSIG) != 0;
        if (cnstrs.length > 0) {
            if (!this.resultOnly) {
                this.M.more("\n" + cnstrHeader);
            }
            boolean firstConstr = true;
            String cname = "";
            for (Constructor<?> cnstr : cnstrs) {
                int modifiers;
                if (firstConstr) {
                    cname = cnstr.getName();
                    int lastDot = cname.lastIndexOf(46);
                    cname = cname.substring(lastDot + 1);
                    firstConstr = false;
                }
                if (((modifiers = cnstr.getModifiers()) & 5) == 0 ? !listDefaultPrivate : !listPublicProtected) continue;
                if (fullSignature) {
                    String modStr = Modifier.toString(modifiers);
                    if (modStr != "") {
                        modStr = modStr + " ";
                    }
                    String signature = this.getSignatureListing(cname, cnstr.getParameters());
                    String listing = modStr + signature;
                    if (!this.resultOnly) {
                        this.M.more(INDENT + listing);
                        continue;
                    }
                    this.listValue = this.listValue + listing + ",";
                    continue;
                }
                String listing = cname;
                if (!this.resultOnly) {
                    this.M.more(INDENT + listing, this.colWidth);
                    continue;
                }
                this.listValue = this.listValue + listing + ",";
            }
            if (!this.resultOnly && !fullSignature) {
                this.M.more(2);
            }
        }
    }

    private void methodsViaReflection(Class<?> clazz) {
        String methodHeader = "Methods - all declared with options " + Parser.mask2s(filterList, this.methodMask & F_ACCESS);
        boolean listPublicProtected = (this.methodMask & F_PUBLIC) != 0;
        boolean listDefaultPrivate = (this.methodMask & F_PRIVATE) != 0;
        ArrayList<String> namesToSort = new ArrayList<String>();
        try {
            Method[] mthds = clazz.getDeclaredMethods();
            if (mthds.length > 0) {
                if (!this.resultOnly) {
                    this.M.more("\n" + methodHeader);
                }
                for (Method mthd : mthds) {
                    int modifiers = mthd.getModifiers();
                    if ((modifiers & 5) != 0 ? !listPublicProtected : !listDefaultPrivate) continue;
                    String mname = mthd.getName();
                    if (this.startsWith && !mname.toLowerCase().startsWith(this.memberName) || this.exactMatch && !mname.toLowerCase().equals(this.memberName)) continue;
                    if ((this.methodMask & F_FULLSIG) != 0) {
                        String modStr = Modifier.toString(modifiers);
                        if (modStr != "") {
                            modStr = modStr + " ";
                        }
                        String signature = this.getSignatureListing(mname, mthd.getParameters());
                        String rtype = mthd.getReturnType().toString();
                        rtype = rtype.replace("class ", "");
                        String listing = modStr + rtype + " " + signature;
                        if (!this.resultOnly) {
                            this.M.more(INDENT + listing);
                            continue;
                        }
                        this.listValue = this.listValue + listing + ",";
                        continue;
                    }
                    namesToSort.add(mname);
                }
                if (!namesToSort.isEmpty()) {
                    this.sortAndListNames(namesToSort);
                }
            }
        }
        catch (Exception e) {
            this.M.warning("New Query via Reflection Method code Exception, please report " + e);
        }
    }

    private String getSignatureListing(String name, Parameter[] params) {
        String paramStr = "";
        if (params.length > 0) {
            paramStr = Arrays.toString(params);
            paramStr = paramStr.substring(1, paramStr.length() - 1);
            paramStr = paramStr.replaceAll("class ", "");
        }
        return name + "(" + paramStr + ")";
    }

    private void fieldsViaReflection(Class<?> clazz) {
        String fieldHeader = "Fields - all declared with options " + Parser.mask2s(filterList, this.fieldMask & F_ACCESS);
        boolean needHeader = !this.resultOnly;
        boolean listPublicProtected = (this.fieldMask & F_PUBLIC) != 0;
        boolean listDefaultPrivate = (this.fieldMask & F_PRIVATE) != 0;
        ArrayList<String> namesToSort = new ArrayList<String>();
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length > 0) {
            for (Field fld : fields) {
                int modifiers = fld.getModifiers();
                if ((modifiers & 5) != 0 ? !listPublicProtected : !listDefaultPrivate) continue;
                String fname = fld.getName();
                if (this.startsWith && !fname.toLowerCase().startsWith(this.memberName) || this.exactMatch && !fname.toLowerCase().equals(this.memberName)) continue;
                if (needHeader) {
                    this.M.more("\n" + fieldHeader);
                    needHeader = false;
                }
                if ((this.fieldMask & F_FULLSIG) != 0) {
                    String modStr = Modifier.toString(modifiers);
                    if (modStr != "") {
                        modStr = modStr + " ";
                    }
                    String ftype = fld.getType().toString();
                    ftype = ftype.replace("class ", "");
                    String value = "";
                    if ((modifiers & 0x10) != 0 && (modifiers & 8) != 0) {
                        fld.setAccessible(true);
                        try {
                            value = " = " + fld.get(null).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String listing = modStr + ftype + " " + fname + value;
                    if (!this.resultOnly) {
                        this.M.more(INDENT + listing);
                        continue;
                    }
                    this.listValue = this.listValue + listing + ",";
                    continue;
                }
                namesToSort.add(fname);
            }
            if (!namesToSort.isEmpty()) {
                this.sortAndListNames(namesToSort);
            }
        }
    }

    private void inheritedMethodsViaReflection(Class<?> clazz) {
        String methodHeader = "Inherited Methods - declared with options " + Parser.mask2s(filterList, this.methodMask & F_INHERIT_INTER);
        boolean needHeader = !this.resultOnly;
        boolean notListInherited = (this.methodMask & F_INHERIT) == 0;
        boolean notListInterface = (this.methodMask & F_INTER) == 0;
        ArrayList<String> namesToSort = new ArrayList<String>();
        try {
            Method[] mthds = clazz.getMethods();
            if (mthds.length > 0) {
                for (Method mthd : mthds) {
                    Class<?> mthdClass = mthd.getDeclaringClass();
                    if (mthdClass.equals(clazz) || Object.class == mthdClass) continue;
                    boolean isInterface = mthdClass.isInterface();
                    if (notListInherited && !isInterface || notListInterface && isInterface && !mthd.isDefault()) continue;
                    String mname = mthd.getName();
                    if (this.startsWith && !mname.toLowerCase().startsWith(this.memberName) || this.exactMatch && !mname.toLowerCase().equals(this.memberName)) continue;
                    if (needHeader) {
                        this.M.more("\n" + methodHeader);
                        needHeader = false;
                    }
                    if (this.userFullSig) {
                        int modifiers = mthd.getModifiers();
                        String modStr = Modifier.toString(modifiers);
                        String signature = this.getSignatureListing(mname, mthd.getParameters());
                        String rtype = mthd.getReturnType().toString().replace("class ", "");
                        String listing = modStr + " " + rtype + " " + signature;
                        if (!this.resultOnly) {
                            this.M.more(INDENT + listing);
                            continue;
                        }
                        this.listValue = this.listValue + listing + ",";
                        continue;
                    }
                    namesToSort.add(mname);
                }
                if (!namesToSort.isEmpty()) {
                    this.sortAndListNames(namesToSort);
                }
            }
        }
        catch (Exception e) {
            this.M.warning("New Query via Reflection Inherited Method code Exception, please report " + e);
        }
    }

    private void sortAndListNames(ArrayList<String> namesToSort) {
        if (!namesToSort.isEmpty()) {
            Object[] sortedNames = namesToSort.toArray(new String[namesToSort.size()]);
            Arrays.sort(sortedNames);
            for (Object listing : sortedNames) {
                if (!this.resultOnly) {
                    this.M.more(INDENT + (String)listing, this.colWidth);
                    continue;
                }
                this.listValue = this.listValue + (String)listing + ",";
            }
        }
        if (!this.resultOnly) {
            this.M.more(2);
        }
    }

    public Object nextChainedObject(Object object) {
        Object nextObject = null;
        if (object instanceof Chainable) {
            nextObject = ((Chainable)object).getNextLink();
        }
        return nextObject;
    }

    public static void setPureReflectionCodeOnly(boolean enable) {
        pureReflectionCodeOnly = enable;
    }

    public static boolean isPureReflectionCodeOnly() {
        return pureReflectionCodeOnly;
    }

    private String getJavaDocsFilename(String fname) {
        if (fname == null) {
            return null;
        }
        String fileName = fname;
        if (fileName.startsWith("nxm.")) {
            String opt = fileName.substring(4, fileName.indexOf(46, 4));
            fileName = Shell.getNmRoot() + "htdocs" + File.separator + "api" + File.separator + opt + File.separator + fileName;
            fileName = fileName.replace('.', File.separatorChar) + ".html";
        } else {
            fileName = null;
        }
        return fileName;
    }

    public void doQuery(Class<?> clas, Object object) {
        this.M.terminal.more(1);
        this.doQuery(clas, object, "ClassName");
        this.M.terminal.more(9);
    }

    private void doQuery(Class<?> clas, Object object, String title) {
        Object nextObj = this.nextChainedObject(object);
        this.M.more(title + " -> " + clas.getName());
        if (Keyable.class.isAssignableFrom(clas)) {
            this.M.more(" *** Class implements Keyable, setKey and getKey may override methods ***");
        }
        this.doQueryClass(clas, this.memberName);
        this.M.more(2);
        if (nextObj != null) {
            this.M.more("");
            this.doQuery(nextObj.getClass(), nextObj, "Chained to Class");
        }
    }

    private void doQueryClass(Class<?> clazz, String name) {
        String constHeader = "Constructors - all declared with options " + Parser.mask2s(filterList, this.constMask);
        String methodHeader = "Methods - all declared with options " + Parser.mask2s(filterList, this.methodMask);
        String fieldHeader = "Fields - all declared with options " + Parser.mask2s(filterList, this.fieldMask);
        ArrayList<Member> consts = new ArrayList<Member>();
        ArrayList<? extends Member> methods = new ArrayList<Member>();
        ArrayList<? extends Member> fields = new ArrayList<Member>();
        if (name.indexOf("*") >= 0) {
            consts.addAll(Arrays.asList(clazz.getConstructors()));
            methods.addAll(Arrays.asList(clazz.getMethods()));
            fields.addAll(Arrays.asList(clazz.getFields()));
            consts.addAll(Query.removePublic(clazz.getDeclaredConstructors()));
            methods.addAll(Query.removePublic(clazz.getDeclaredMethods()));
            fields.addAll(Query.removePublic(clazz.getDeclaredFields()));
            String[] sortedConsts = Query.sortNames(clazz, consts.toArray(new Member[0]), name, this.constMask);
            String[] sortedMethods = Query.sortNames(clazz, methods.toArray(new Member[0]), name, this.methodMask);
            String[] sortedFields = Query.sortNames(clazz, fields.toArray(new Member[0]), name, this.fieldMask);
            this.listInfo(constHeader, sortedConsts, clazz, this.constMask);
            this.listInfo(methodHeader, sortedMethods, clazz, this.methodMask);
            this.listInfo(fieldHeader, sortedFields, clazz, this.fieldMask);
        } else if (clazz.equals(Table.class) || clazz.equals(KeyVector.class)) {
            this.M.more(" *** Only getKey and setKey can be used ***");
            this.M.more(2);
        } else if (clazz.isArray()) {
            this.M.more(" *** Only getSize() and array access methods can be used ***");
            this.M.more(2);
        } else {
            Member[] members;
            String key = name.equals("*") ? null : name;
            Class<?>[] types = null;
            for (Member member : members = KeyObject.findMembers(clazz, key, types, false)) {
                if (member instanceof Constructor) {
                    consts.add((Constructor)member);
                    continue;
                }
                if (member instanceof Method) {
                    methods.add((Method)member);
                    continue;
                }
                if (!(member instanceof Field)) continue;
                fields.add((Field)member);
            }
            String[] sortedConsts = Query.sortNames(clazz, consts.toArray(new Member[0]), name, this.constMask);
            String[] sortedMethods = Query.sortNames(clazz, methods.toArray(new Member[0]), name, this.methodMask);
            String[] sortedFields = Query.sortNames(clazz, fields.toArray(new Member[0]), name, this.fieldMask);
            this.listInfo(constHeader, sortedConsts, clazz, this.constMask);
            this.listInfo(methodHeader, sortedMethods, clazz, this.methodMask);
            this.listInfo(fieldHeader, sortedFields, clazz, this.fieldMask);
        }
    }

    private static List<? extends Member> removePublic(Member[] members) {
        ArrayList<Member> list3 = new ArrayList<Member>();
        for (Member member : members) {
            if (Modifier.isPublic(member.getModifiers())) continue;
            list3.add(member);
        }
        return list3;
    }

    private void listInfo(String header, String[] list3, Class<?> clazz, int mask) {
        if (mask == 0) {
            return;
        }
        if (this.listName != null) {
            for (int i = 0; i < list3.length; ++i) {
                this.listValue = this.listValue == null ? list3[i] : this.listValue + "," + list3[i];
            }
            return;
        }
        this.M.more(" " + header + " (" + list3.length + ") -> ");
        for (int i = 0; i < list3.length; ++i) {
            this.M.more(INDENT + list3[i], this.colWidth);
        }
        this.M.more(2);
    }

    private static Class<?>[] getTypes(String args) {
        String[] paramStrs;
        Class[] params = null;
        if ((args = args.trim()).startsWith("(") && args.endsWith(")")) {
            args = args.substring(1, args.length() - 1);
        }
        if ((paramStrs = args.split(",")).length == 1 && paramStrs[0].trim().length() == 0) {
            params = new Class[]{};
        } else {
            params = new Class[paramStrs.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = Query.getClass(paramStrs[i].trim());
                if (params[i] != null) continue;
                Shell.warning("Unknown type '" + paramStrs[i] + "'.");
                params = null;
                break;
            }
        }
        return params;
    }

    private static String[] sortNames(Class<?> clazz, Member[] objArray, String memberName, int mask) {
        ArrayList<String> nameList = new ArrayList<String>();
        boolean all = memberName.equals("*");
        boolean exact = memberName.indexOf(40) >= 0;
        boolean fullSig = (mask & F_FULLSIG) != 0;
        int istar = memberName.indexOf("*");
        if (istar > 0) {
            memberName = memberName.substring(0, istar);
        }
        Class<?>[] params = null;
        if (exact) {
            int pStart = memberName.indexOf(40);
            int pEnd = memberName.indexOf(41);
            if (pEnd > 0) {
                params = Query.getTypes(memberName.substring(pStart + 1, pEnd));
            }
            memberName = memberName.substring(0, pStart).trim();
        }
        String memberNameUC = memberName.toUpperCase();
        String memberNameCS = memberName;
        try {
            for (int i = 0; i < objArray.length; ++i) {
                boolean isInterface;
                Member member = objArray[i];
                String sig = member.toString();
                String name = member.getName();
                int mods = member.getModifiers();
                String signame = fullSig ? sig : name;
                boolean isInherited = member.getDeclaringClass() != clazz;
                boolean bl = isInterface = isInherited && member.getDeclaringClass().isInterface();
                if (isInterface) {
                    isInherited = false;
                }
                if (member instanceof Constructor) {
                    name = "<init>";
                }
                if (Modifier.isPrivate(mods) && (mask & F_PRIVATE) == 0 || Modifier.isPublic(mods) && (mask & F_PUBLIC) == 0 || isInherited && (mask & F_INHERIT) == 0 || isInterface && (mask & F_INTER) == 0) continue;
                if (all) {
                    nameList.add(signame);
                    continue;
                }
                if (member instanceof Field && name.equals(memberNameCS)) {
                    nameList.add(signame);
                    continue;
                }
                if (exact && name.equals(memberNameCS)) {
                    if (params != null) {
                        Class<?>[] methParams = null;
                        if (member instanceof Method) {
                            methParams = ((Method)member).getParameterTypes();
                        } else {
                            if (!(member instanceof Constructor)) {
                                nameList.add(sig);
                                break;
                            }
                            methParams = ((Constructor)member).getParameterTypes();
                        }
                        if (methParams.length != params.length) continue;
                        boolean match = true;
                        for (int j = 0; j < params.length; ++j) {
                            match = match && params[j].equals(methParams[j]);
                        }
                        if (!match) continue;
                        nameList.add(signame);
                        continue;
                    }
                    nameList.add(signame);
                    continue;
                }
                if (exact || !name.toUpperCase().startsWith(memberNameUC)) continue;
                nameList.add(signame);
            }
        }
        catch (IllegalArgumentException e) {
            Shell.warning("Can not load an array of " + objArray.getClass());
        }
        Object[] sortedList = nameList.toArray(new String[0]);
        Arrays.sort(sortedList);
        return sortedList;
    }

    private static Class<?> getClass(String str) {
        String[] PACKAGE_SEARCH = new String[]{"", "java.lang.", "java.util.", "nxm.sys.inc.", "nxm.sys.lib.", "nxm.sys.libg.", "nxm.sys.libm.", "nxm.sys.net."};
        Class<Constable> clazz = null;
        if (str.equals("long")) {
            clazz = Long.TYPE;
        }
        if (str.equals("int")) {
            clazz = Integer.TYPE;
        }
        if (str.equals("short")) {
            clazz = Short.TYPE;
        }
        if (str.equals("char")) {
            clazz = Character.TYPE;
        }
        if (str.equals("byte")) {
            clazz = Byte.TYPE;
        }
        if (str.equals("double")) {
            clazz = Double.TYPE;
        }
        if (str.equals("float")) {
            clazz = Float.TYPE;
        }
        if (str.equals("boolean")) {
            clazz = Boolean.TYPE;
        }
        for (int i = 0; clazz == null && i < PACKAGE_SEARCH.length; ++i) {
            try {
                clazz = Class.forName(PACKAGE_SEARCH[i] + str);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz;
    }
}

