/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.Installation;
import nxm.sys.inc.ListFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.ICEPacket;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;

public class Keyword
extends Intrinsic {
    private static final boolean OLD_LISTING_FORMAT = false;

    @Override
    public int process() {
        boolean useOldListing;
        boolean hasFlags;
        boolean warn = this.MA.getState("/WARN", true);
        boolean flat = this.MA.getState("/FLAT", Shell.getMidasContext().io.getOptions().indexOf("SetKeywordDefaultFlatValueToFalse") <= -1);
        String origFunc = this.MA.getU("FUNC");
        String func = origFunc.replace("SET", "PUT");
        DataFile hcb = this.MA.getDataFile("FILE");
        if (func.indexOf("PUT") >= 0 || func.indexOf("ADD") >= 0 || func.indexOf("DEL") == 0) {
            hcb.open(1027);
        } else {
            hcb.open(1025);
        }
        if (!hcb.isOpen) {
            return 9;
        }
        String scope = this.MA.getU("/SCOPE");
        if (scope.length() > 0 && hcb.keywords.setScope(scope) == 0) {
            this.M.error("Could not set scope to " + scope);
        }
        if (hasFlags = this.MA.isPresent("/FLAGS")) {
            hcb.keywords.setFlags(this.MA.getU("/FLAGS"));
        }
        if ((useOldListing = this.MA.getState("/LEGACYLIST")) && func.equals("LIST")) {
            if (!hasFlags) {
                hcb.keywords.setFlags(1);
            }
            String name = this.MA.getS("NAME", null);
            this.M.more(1);
            Keywords.Iterator kwi = hcb.keywords.iterator();
            while (kwi.getNext() && this.M.more()) {
                if (name != null && !StringUtil.isWildcardMatch(name, kwi.name)) continue;
                this.M.more(kwi.list());
            }
            this.M.more(9);
        } else if (func.equals("LIST") || func.startsWith("LIST/")) {
            if (!hasFlags) {
                hcb.keywords.setFlags(1);
            }
            String filter = this.MA.getS("NAME", null);
            boolean sort2 = func.contains("/S");
            int mainKeywordsListed = 0;
            int keywordsListed = 0;
            this.M.more(1);
            if (scope == null || scope.isEmpty() || scope.equals("ALL")) {
                this.M.println("==== MAIN HEADER ==================================");
                for (Map.Entry<String, Object> kwd : hcb.keywords.getAll("MAIN", sort2)) {
                    if (filter != null && !StringUtil.isWildcardMatch(filter, kwd.getKey())) continue;
                    this.M.println(Keywords.list(kwd, "MAIN", 24, 512));
                    ++mainKeywordsListed;
                }
                this.M.println("");
                this.M.println("==== EXTENDED HEADER ==============================");
                for (Map.Entry<String, Object> kwd : hcb.keywords.getAll("EXT", sort2)) {
                    if (filter != null && !StringUtil.isWildcardMatch(filter, kwd.getKey())) continue;
                    this.M.println(Keywords.list(kwd, "EXT", 24, 512));
                    ++keywordsListed;
                }
            } else {
                for (Map.Entry<String, Object> kwd : hcb.keywords.getAll(scope, sort2)) {
                    if (filter != null && !StringUtil.isWildcardMatch(filter, kwd.getKey())) continue;
                    this.M.println(Keywords.list(kwd, scope, 24, 512));
                    ++keywordsListed;
                }
            }
            this.M.more(9);
            this.M.println("");
            this.M.println("==== KEYWORD STATS ================================");
            if (scope == null || scope.isEmpty() || scope.equals("ALL")) {
                this.M.println("Number of keywords listed: MAIN = " + mainKeywordsListed + "  EXT = " + keywordsListed);
            } else {
                this.M.println("Number of keywords listed: " + scope + " = " + keywordsListed);
            }
        } else if (func.equals("GET")) {
            int argCount = 3;
            boolean moreArgs = true;
            while (moreArgs && argCount <= this.MA.getNArgs()) {
                String name = this.MA.getU(argCount);
                ++argCount;
                moreArgs = !name.isEmpty();
                if (!moreArgs) continue;
                String label = this.MA.getU(argCount);
                ++argCount;
                boolean bl = moreArgs = !label.isEmpty();
                if (moreArgs) {
                    if (scope.equals("MAIN")) {
                        this.MR.put(label, (Object)hcb.keywords.getMain(name));
                        continue;
                    }
                    this.MR.put(label, hcb.keywords.get(name));
                    continue;
                }
                this.M.warning("Unbalanced keyword NAME = '" + name + "'. Missing LABEL pairing for GET");
            }
        } else if (func.equals("PUT")) {
            this.insert("PUT", scope, hcb, warn);
        } else if (func.equals("ADD")) {
            this.insert("ADD", scope, hcb, warn);
        } else if (func.startsWith("DEL")) {
            String name = this.MA.getU("NAME");
            if (scope.equals("MAIN")) {
                hcb.keywords.deleteMain(name);
            } else {
                hcb.keywords.delete(name);
            }
        } else if (func.equals("FGET")) {
            TextFile tf;
            if (this.MA.getLength("NAME") > 0) {
                tf = this.MA.getTextFile("NAME");
            } else {
                FileName fn = this.MA.getFileName("FILE");
                fn.setExt("key");
                tf = new TextFile(this, (Object)fn);
            }
            tf.open(8194);
            hcb.keywords.dump(tf);
            tf.close();
        } else if (func.equals("FPUT")) {
            TextFile tf;
            if (this.MA.getLength("NAME") > 0) {
                tf = this.MA.getTextFile("NAME");
            } else {
                FileName fn = this.MA.getFileName("FILE");
                fn.setExt("key");
                tf = new TextFile(this, (Object)fn);
            }
            tf.open(8193);
            hcb.keywords.clear();
            if (this.MA.getState("/EXTONLY", Installation.ApplyBugFix.KEYWORD_FSET_INTO_EXTENDED_ONLY)) {
                hcb.keywords.loadExt(tf);
            } else {
                hcb.keywords.load(tf);
            }
            tf.close();
        } else if (func.startsWith("SVGET")) {
            this.svget(func, hcb);
        } else if (func.startsWith("SVPUT")) {
            this.svset(func, hcb);
        } else if (func.startsWith("TCGET")) {
            this.tcget(func, hcb);
        } else if (func.startsWith("TCPUT")) {
            this.tcset(func, hcb);
        } else if (func.startsWith("TCDEL")) {
            this.tcdel(hcb);
        } else if (func.startsWith("NTCDEL")) {
            this.ntcdel(hcb);
        } else if (func.startsWith("TGET")) {
            String name = this.MA.getU("NAME", hcb.getFileName().getTag());
            Table tb = hcb.keywords.makeTable(flat);
            if (func.indexOf("/F") >= 0) {
                tb.toTextFile(this.MA.getTextFile("NAME"));
            } else {
                this.MR.put(name, (Object)tb);
            }
        } else if (func.startsWith("TPUT")) {
            Table tbl = this.MA.getTable("NAME");
            Table.Iterator ti = tbl.iterator();
            while (ti.getNext()) {
                hcb.keywords.put(ti.key, ti.value);
            }
        } else {
            this.M.warning("Unsupported function: " + origFunc);
        }
        hcb.close();
        return 9;
    }

    private void insert(String func, String scope, DataFile hcb, boolean warn) {
        int argCount = 3;
        boolean moreArgs = true;
        while (moreArgs && argCount <= this.MA.getNArgs()) {
            String name = this.MA.getU(argCount);
            ++argCount;
            moreArgs = !name.isEmpty();
            if (!moreArgs) continue;
            Object value = this.MA.getO(argCount);
            ++argCount;
            boolean bl = moreArgs = value != null;
            if (moreArgs) {
                if (scope.equals("MAIN")) {
                    hcb.keywords.putMain(name, value.toString(), warn);
                    continue;
                }
                if (func.equals("PUT")) {
                    hcb.keywords.put(name, value);
                    continue;
                }
                if (func.equals("ADD")) {
                    hcb.keywords.add(name, value);
                    continue;
                }
                this.M.warning("KEYWORD: Invalid FUNC = '" + func + "'. Function must be 'PUT' or 'ADD'.");
                continue;
            }
            this.M.warning("Unbalanced keyword NAME = '" + name + "'. Missing VALUE pairing for PUT");
        }
    }

    private void svget(String func, DataFile hcb) {
        Time t0;
        List<Table> rows;
        Double dt;
        Position.SVMode svMode;
        StateVector sv = new StateVector();
        String modifier = func.substring(5);
        if (modifier.isEmpty()) {
            svMode = null;
        } else if (modifier.equals("/E")) {
            svMode = Position.SVMode.KeywordsEph;
        } else if (modifier.equals("/L")) {
            svMode = Position.SVMode.KeywordsLLA;
        } else if (modifier.equals("/P")) {
            svMode = Position.SVMode.KeywordsPlat;
        } else if (modifier.equals("/V")) {
            svMode = Position.SVMode.KeywordsVec;
        } else {
            throw new MidasException("Expected only /E, /L, /P, or /V given " + modifier);
        }
        sv.setFile(this, (Object)hcb.getName(), hcb.getFlags(), svMode);
        Transform t = sv.getTransform();
        ListFile lf = this.MA.getFile("NAME", ListFile.class);
        boolean t5 = false;
        Double d = dt = this.MA.find("/DT") ? Double.valueOf(this.MA.getD("/DT")) : null;
        if (dt != null && dt < 0.0) {
            dt = null;
        }
        lf.open(2050);
        if (lf instanceof DataFile) {
            DataFile df = (DataFile)lf;
            if (df.getType() < 3000) {
                df.setType(5001);
            }
            if (df.getTypeCodeClass() == 5) {
                t.toDataFile(df);
                t5 = true;
            }
        }
        if (lf.getRecordDefCount() == 0) {
            lf.setRecordDefs(sv.toFileRecDefs());
        }
        List<Table> list3 = rows = t5 || dt != null ? sv.toFileEntries(null, null, dt, "ECR") : sv.toFileEntries("ECR");
        if (rows.size() < 2) {
            t0 = Time.toTime(rows.get(0).get("TIME"));
            dt = 60.0;
        } else {
            t0 = Time.toTime(rows.get(0).get("TIME"));
            Time t1 = Time.toTime(rows.get(1).get("TIME"));
            dt = t1.diff(t0);
            Time lastTime = t1;
            for (int i = 2; i < rows.size(); ++i) {
                Time thisTime = Time.toTime(rows.get(i).get("TIME"));
                double delta = thisTime.diff(lastTime);
                if (Math.abs(dt - delta) > 1.0E-6) {
                    throw new MidasException("StateVector.toFileEntries(..) returned bad data!");
                }
                lastTime = thisTime;
            }
        }
        if (lf instanceof DataFile) {
            DataFile df = (DataFile)lf;
            if (t5) {
                double wsod = t0.getWSec() % 86400.0;
                double fsod = t0.getFSec();
                df.setTime(new Time(t0.getWSec() - wsod, 0.0));
                t0 = new Time(wsod, fsod);
            }
            df.setStart(t0.getSec());
            df.setDelta(dt);
            df.setUnits(1);
            df.setSize(0.0);
        }
        for (int i = 0; i < rows.size(); ++i) {
            lf.setData(i, rows.get(i));
        }
        lf.close();
    }

    private void svset(String func, DataFile hcb) {
        Keywords keys = hcb.getKeywordsObject();
        StateVector sv = new StateVector();
        String modifiers = func.substring(5);
        if (modifiers.isEmpty()) {
            throw new MidasException("Must specify output format(s) via modifier(s) on SVSET.");
        }
        sv.setFile(this, (Object)this.MA.getFileName("NAME"), 0, null);
        if (modifiers.contains("/E")) {
            keys.putAll(sv.toKeywordsEph());
        }
        if (modifiers.contains("/L")) {
            keys.putAll(sv.toKeywordsLLA(hcb));
        }
        if (modifiers.contains("/P")) {
            keys.putAll(sv.toKeywordsPlat(hcb));
        }
        if (modifiers.contains("/V")) {
            keys.putAll(sv.toKeywordsVec());
        }
    }

    private void tcget(String func, DataFile hcb) {
        String modifiers = func.substring(5);
        if (modifiers.isEmpty()) {
            throw new MidasException("Must specify format via modifier(s) on TCGET.");
        }
        if (!modifiers.equals("/I/X") && !modifiers.equals("/X/I")) {
            throw new MidasException("Unsupported format modifier(s) '" + modifiers + "' on TCGET.");
        }
        this.tcgetICE(hcb);
    }

    private void tcset(String func, DataFile hcb) {
        String modifiers = func.substring(5);
        if (modifiers.isEmpty()) {
            throw new MidasException("Must specify format via modifier(s) on SVSET.");
        }
        if (!modifiers.equals("/I/X") && !modifiers.equals("/X/I")) {
            throw new MidasException("Unsupported format modifier(s) '" + modifiers + "' on SVSET.");
        }
        this.tcsetICE(hcb);
    }

    private void tcgetICE(DataFile hcb) {
        Keywords kwds = hcb.getKeywordsObject();
        LinkedList<ICEPacket> pkts = new LinkedList<ICEPacket>();
        ICEPacket lastPkt = null;
        double lastSample = 0.0;
        double lastTcoff = 0.0;
        int allSize = 0;
        double totSize = 0.0;
        int count = 0;
        int i = 1;
        while (kwds.find("TC_WHOLE_" + i) != null) {
            ICEPacket pkt = new ICEPacket(hcb.getFormat(), 0, 0);
            double sample = kwds.getD("TCSAMPLE_" + i, 0.0);
            double wsec = kwds.getD("TC_WHOLE_" + i, 0.0);
            double fsec = kwds.getD("TC_FRAC_" + i, 0.0);
            double tcoff = kwds.getD("TC_OFFSET_" + i, 0.0);
            count = kwds.getL("PACKET_" + i, count + 1);
            if (i > 1) {
                double actSize = sample - lastSample - tcoff + lastTcoff;
                double residual = totSize - Math.rint(totSize);
                int size = (int)Math.rint(actSize + residual);
                double error = actSize - (double)size;
                lastPkt.setSize(size);
                totSize += actSize;
                if (error >= 1.0E-7 || error <= -1.0E-7) {
                    this.M.warning("Bad packet size for TCSAMPLE_" + i + " " + actSize + " using " + size);
                }
                if (i == 2) {
                    allSize = size;
                }
                if (size != allSize) {
                    allSize = -size;
                }
            }
            lastPkt = pkt;
            lastSample = sample;
            lastTcoff = tcoff;
            pkt.setCount(count);
            pkt.setChannel(0);
            pkt.setTC(0, 1, tcoff, wsec, fsec);
            pkts.add(pkt);
            ++i;
        }
        if (pkts.size() < 2) {
            this.M.warning("Found less than two complete sets of TC keys");
            kwds.clear();
        } else if (allSize > 0) {
            lastPkt.setSize(allSize);
        } else {
            this.M.warning("Inconsistent packet size");
            lastPkt.setSize((int)Math.rint(hcb.getSize() - totSize));
        }
        DataFile out = this.MA.getDataFile("NAME", "3000", "NH", 2);
        out.open();
        out.setSubRecords("KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD,RBST|SL,RBSZ|SL,RBDO|SL,RBDS|SL");
        out.setXStart(0.0);
        if (allSize > 0) {
            out.setXDelta(hcb.getXDelta() * (double)allSize);
        }
        out.setXUnits(1);
        out.setSize(pkts.size());
        for (ICEPacket pkt : pkts) {
            out.write(pkt.buf, 0, 64);
        }
        out.close();
    }

    private void tcsetICE(DataFile hcb) {
        DataFile in = this.MA.getDataFile("NAME", "3000", "NH", 1);
        Keywords kwds = hcb.getKeywordsObject();
        ICEPacket pkt = new ICEPacket();
        int i = 1;
        double lastSample = 0.0;
        double lastTCOff = 0.0;
        in.open();
        while (in.read(pkt.buf, 0, 64) == 64) {
            double tcoff;
            Time tc;
            if (pkt.hasSync() && pkt.getTCStatus() > 0) {
                tc = pkt.getTC();
                tcoff = pkt.getTCO();
            } else {
                tc = new Time(0.0, 0.0);
                tcoff = 0.0;
            }
            double sample = i == 1 ? tcoff + 1.0 : lastSample + (tcoff - lastTCOff) + (double)(pkt.getSize() - pkt.getUser());
            kwds.put("D:TC_WHOLE_" + i, tc.getWSec());
            kwds.put("D:TC_FRAC_" + i, tc.getFSec());
            kwds.put("D:TC_OFFSET_" + i, tcoff);
            kwds.put("D:TCSAMPLE_" + i, sample);
            ++i;
            lastSample = sample;
            lastTCOff = tcoff;
        }
        in.close();
    }

    private void tcdel(DataFile hcb) {
        hcb.open(3);
        hcb.deleteTimeLineKeywords();
        hcb.close();
    }

    private void ntcdel(DataFile hcb) {
        hcb.open(3);
        hcb.deleteNonTimeLineKeywords();
        hcb.close();
    }
}

