/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Stack;

public class History
extends Intrinsic {
    private int maxCommands = 64;
    private Shell shell;
    private Stack history;
    private boolean caseSensitive = false;

    @Override
    public int process() {
        this.caseSensitive = this.MA.getState("/CS", this.caseSensitive);
        String cmd = this.MA.getCS("CMD");
        short num = this.MA.getI("NUM");
        this.shell = this.M.terminal.getShell();
        if (this.shell == null) {
            this.shell = (Shell)this.M.registry.get("SHELL");
        }
        this.history = this.shell.getHistory();
        this.matchCommands(cmd, num);
        this.rewind();
        return 9;
    }

    private void matchCommands(String cmdAsEntered, int matchNum) {
        Stack answer = new Stack(this.maxCommands);
        Object peekobj = this.history.peek(-1);
        int cmdnum = 1;
        int matches = 0;
        String cmd = cmdAsEntered;
        if (!this.caseSensitive) {
            cmd = cmd.toUpperCase();
        }
        while (peekobj != null && cmdnum <= this.maxCommands) {
            String strAsEntered;
            String str = strAsEntered = (String)peekobj;
            if (!this.caseSensitive) {
                str = str.toUpperCase();
            }
            if (str.startsWith(cmd) && (matchNum == 0 || ++matches <= matchNum)) {
                answer.push(" " + strAsEntered);
            }
            peekobj = this.history.peek(-1);
            ++cmdnum;
        }
        Object obj = answer.pop();
        while (obj != null) {
            this.M.println(obj.toString());
            obj = answer.pop();
        }
    }

    private void rewind() {
        Object peekobj = this.history.peek(1);
        while (peekobj != null) {
            peekobj = this.history.peek(1);
        }
    }
}

