/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import nxm.sys.inc.LegacyMethod;
import nxm.sys.intr.HelpSwap;
import nxm.sys.lib.Args;
import nxm.sys.lib.Build;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import tools.BuildProps;

public class Help
extends HelpSwap {
    static final String NMROOT = Shell.getNmRoot();
    static final String JAVADOC_PATH = NMROOT + "htdocs" + File.separator + "api" + File.separator;
    static final String HELP_PATH = NMROOT + "htdocs" + File.separator + "help" + File.separator;
    private static final String STYLE_SHEET_HREF = "../../nxm/sys/docs/style.css";
    private static final String mainFileName = "mainhelp.hlp";
    private static final String configFileName = "mainhelp.cnf";
    private TextFile fcnf;
    private TextFile fmhs;
    private TextFile fall;
    private String jhdir;
    private boolean inTable;
    private static final Pattern VALID_COMMAND_REGEX = Pattern.compile("\\p{Alpha}[\\w;]*");
    private String opt;
    private String[] opts;
    private RunMode runMode;

    private void initBuildProps() {
        if (this.sysBuildProps == null) {
            this.sysBuildProps = BuildProps.getPropsFor("SYS");
        }
    }

    @Override
    public int open() {
        super.open();
        this.sysBuildProps = null;
        this.inTable = false;
        this.opt = this.MA.getU("OPT", "ALL");
        this.debug = this.MA.getState("/DEBUG");
        if (this.opt.equals("ALL")) {
            String path = (String)this.M.results.get("OPT.PATH");
            this.opts = StringUtil.cleanSplit(path, ",");
        } else {
            this.opts = new String[]{this.opt};
        }
        this.runMode = this.MA.getState("/INDEX") ? RunMode.INDEX : (this.MA.getState("/BUILD") ? RunMode.BUILD : (this.MA.getState("/GUI") ? RunMode.GUI : (this.MA.getState("/LITEGUI") ? RunMode.LiteGUI : (this.MA.getState("/LEGACY", true) ? RunMode.LegacyCLI : RunMode.CLI))));
        switch (this.runMode) {
            case INDEX: 
            case GUI: 
            case LiteGUI: 
            case CLI: {
                this.initBuildProps();
                break;
            }
        }
        return 0;
    }

    @Override
    public int process() {
        if (this.runMode == RunMode.INDEX) {
            return this.runLuceneIndex();
        }
        if (this.runMode == RunMode.GUI) {
            return this.runLuceneGUI();
        }
        if (this.runMode == RunMode.LiteGUI) {
            return this.runLuceneLiteGUI();
        }
        if (this.runMode == RunMode.BUILD) {
            FileName fn;
            String jddir = null;
            String[] pathList = new String[]{Shell.getNmRoot(), "htdocs", "api"};
            if (this.MA.find("/LOCAL")) {
                if (this.opt.equals("ALL")) {
                    this.M.error("Option name must accompany /LOCAL");
                }
                pathList[0] = Shell.getOptPath(this.opt, "");
                pathList[1] = "docs";
                fn = new FileName(pathList, "", "");
                jddir = fn.getFullName();
            }
            if (jddir == null) {
                this.M.info("Building JavaDocs for opt=" + this.opt + " in " + JAVADOC_PATH);
            } else {
                this.M.info("Building JavaDocs for opt=" + this.opt + " in " + jddir);
            }
            Build.setMidasContext(this.M);
            Build.compileDocs(this.opt, jddir, this.debug);
            pathList[2] = "help";
            fn = new FileName(pathList, "", "");
            this.jhdir = fn.getFullName();
            this.M.info("Building help for opt=" + this.opt + " in " + this.jhdir);
            int status = 0;
            for (String opt : this.opts) {
                status += this.buildMainHelp(opt);
            }
            for (String opt : this.opts) {
                status += this.buildHelp(opt);
            }
            if ((status += this.buildMasterIndex()) < 0) {
                this.M.warning("Encountered " + -status + " problems while building Help.");
            }
            return 9;
        }
        if (this.runMode == RunMode.LegacyCLI) {
            String helpItemName = this.MA.getU("NAME", "MAINHELP");
            this.doLegacySearch(helpItemName, this.opt, this.opts);
        } else {
            this.runLuceneSearchInteraction();
        }
        return 9;
    }

    @Override
    public int close() {
        return super.close();
    }

    private void doLegacySearch(String name, String opt, String[] opts) {
        ArrayList<Key> list3 = new ArrayList<Key>(128);
        Args args = Shell.parseCommand(this.M, name);
        if (!args.name.equals("") && (opt.equals("ALL") || args.option.equals(opt))) {
            Key key = new Key();
            key.type = "EXPLAIN";
            key.label = args.name;
            key.opt = args.option;
            list3.add(key);
        }
        if (name.equals("MAINHELP") && opt.equals("ALL")) {
            opts = new String[]{"SYS"};
        }
        for (String optionTree : opts) {
            this.searchMainHelp(optionTree, name, list3);
        }
        this.M.println("Search for key=" + name + " in opt=" + opt + " yields " + list3.size() + " entries:");
        if (list3.size() > 1) {
            this.listEntries(list3);
        }
        boolean bl = false;
        while (list3.size() > 0) {
            int n;
            String ans = "N";
            if (list3.size() > 1) {
                ans = this.M.terminal.getInput("Enter item number or [N]ext/Quit/List ?: ", "");
            }
            if ((ans = ans.length() == 0 ? "N" : ans.trim().toUpperCase()).startsWith("Q")) break;
            if (ans.startsWith("L")) {
                this.listEntries(list3);
            } else {
                if (ans.startsWith("N")) {
                    if (n == list3.size()) {
                        break;
                    }
                } else {
                    n = Convert.s2l(ans);
                }
                Key key = list3.get(n %= list3.size());
                if (key.type.equals("EXPLAIN")) {
                    this.doExplainFileEntry(key.label, key.opt);
                } else {
                    this.doHelpTreeEntry(key.file, key.label, key.opt);
                }
            }
            ++n;
        }
    }

    private void searchMainHelp(String opt, String keyword, List<Key> list3) {
        String text;
        String fn = this.M.io.name("HLP", "MAINHELP", "HLP", opt);
        TextFile tf = new TextFile(this.M, (Object)fn);
        if (!tf.find(-1)) {
            return;
        }
        if (!tf.open(32)) {
            return;
        }
        String filename = null;
        while ((text = tf.read()) != null) {
            Key key = this.parseKey(text);
            if (key == null) continue;
            if (key.type.equals("FILE")) {
                int iDupMain;
                filename = key.label;
                key.file = "MAINHELP";
                key.opt = opt;
                if (key.label.indexOf(keyword) < 0 || (iDupMain = this.mainHelpInList(list3)) >= 0) continue;
                list3.add(key);
                continue;
            }
            if (!key.type.equals("ENTRY")) continue;
            key.file = filename;
            key.opt = opt;
            if (key.label.indexOf(keyword) < 0 || key.file.equals("MAINHELP") && this.mainHelpInList(list3) >= 0) continue;
            list3.add(key);
        }
        tf.close();
    }

    private int mainHelpInList(List<Key> list3) {
        int index = -1;
        for (int i = 0; i < list3.size(); ++i) {
            Key key = list3.get(i);
            if (key.file == null || !key.file.equals("MAINHELP")) continue;
            index = i;
            break;
        }
        return index;
    }

    private void listEntries(List<Key> list3) {
        this.M.more(1);
        for (int i = 0; i < list3.size(); ++i) {
            Key key = list3.get(i);
            String type = "Help Item  ";
            if (key.type.equals("FILE")) {
                type = "Help File  ";
            }
            if (key.type.equals("EXPLAIN")) {
                type = "Explain On ";
            }
            String file = key.file == null ? "" : " file=" + key.file;
            String index = " " + i + ") ";
            if (i < 10) {
                index = " " + index;
            }
            this.M.more(index + type + key.label + "   in" + file + " opt=" + key.opt);
        }
        this.M.more(9);
    }

    private void doExplainFileEntry(String name, String opt) {
        String text;
        String fname = this.M.io.name("EXP", name, "EXP", opt);
        TextFile tf = new TextFile(this.M, (Object)fname);
        if (!tf.open(32)) {
            return;
        }
        this.M.more(1);
        while (this.M.more() && (text = tf.read()) != null) {
            this.M.more(text);
        }
        this.M.more(9);
        tf.close();
    }

    private int doHelpTreeEntry(String filename, String keyword, String opt) {
        Key key;
        TextFile tf;
        String fname;
        String text = null;
        String infname = filename;
        ArrayList<Key> list3 = new ArrayList<Key>(16);
        if (filename.equals("DOCUMENTS")) {
            fname = this.M.io.name("HLP", keyword, "DOC", opt);
            if (!this.M.io.find(fname)) {
                fname = this.M.io.name("DOCS", keyword, "DOC", opt);
            }
        } else {
            fname = filename.equals("INCLUDES") ? this.M.io.name("INC", keyword, "INC", opt) : this.M.io.name("HLP", filename, "HLP", opt);
        }
        if (!(tf = new TextFile(this.M, (Object)fname)).open(33)) {
            this.M.warning("HELP: Could not find " + tf.getName());
            return 0;
        }
        if (keyword.equals("")) {
            text = tf.read();
        } else if (filename.equals("INCLUDES")) {
            text = "Include File: " + fname;
        } else if (filename.equals("DOCUMENTS")) {
            text = "Document File: " + fname;
        } else {
            while ((text = tf.read()) != null) {
                key = this.parseKey(text);
                if (key == null) continue;
                if (key.type.equals("FILE") && infname.equals("MAINHELP")) {
                    filename = key.label;
                    if (key.label.indexOf(keyword) < 0) continue;
                    text = "Help Category: " + opt + "_" + key.label;
                    break;
                }
                if (!key.type.equals("SECTION") && !key.type.equals("FUNCTION") || key.label.indexOf(keyword) < 0) continue;
                text = "Help Entry: " + opt + "_" + filename + "_" + key.label;
                break;
            }
        }
        if (text == null) {
            this.M.error("Help Format Err: Section " + keyword + " not found in " + infname);
        }
        this.M.more(1);
        this.M.more(text);
        while (this.M.more() && (text = tf.read()) != null) {
            key = this.parseKey(text);
            if (key != null) {
                if (key.type.equals("ENTRY")) {
                    key.file = filename;
                    list3.add(key);
                } else {
                    if (!key.type.equals("INCLUDE")) break;
                    this.doHelpTreeEntry(key.file, "", opt);
                }
            }
            this.M.more(text);
        }
        this.M.more(9);
        if (list3.size() > 0) {
            text = this.M.terminal.getInput("Item in " + keyword + " to explore ?: ", "");
            text = text.toUpperCase();
        }
        tf.close();
        if (text == null || text.length() == 0) {
            return 0;
        }
        int stat = 0;
        for (Key key2 : list3) {
            if (key2.label.indexOf(text) < 0) continue;
            String ans = this.M.terminal.getInput("Explore " + key2.label + " in " + opt + "_" + key2.file + " [Y]/N/Q ?: ", "");
            if ((ans = ans.toUpperCase()).startsWith("N")) continue;
            if (ans.startsWith("Q")) {
                return -1;
            }
            stat = this.doHelpTreeEntry(key2.file, key2.label, opt);
        }
        return stat;
    }

    private Key parseKey(String text) {
        int i;
        text = text.replaceAll("\\s+", " ");
        int len = text.length();
        for (i = 0; i < len && text.charAt(i) <= ' '; ++i) {
        }
        if (i == len) {
            return null;
        }
        Key key = null;
        if (text.charAt(i) == '~') {
            key = new Key();
            int j = ++i;
            while (i < len && text.charAt(i) > ' ') {
                ++i;
            }
            key.type = text.substring(j, i).toUpperCase();
            while (i < len && text.charAt(i) == ' ') {
                ++i;
            }
            for (j = i; j < len && text.charAt(j) != ' '; ++j) {
            }
            if (key.type.equals("INCLUDE")) {
                key.file = text.substring(i, j);
            }
            key.label = text.substring(i, j).toUpperCase();
            while (j < len && (text.charAt(j) == ' ' || text.charAt(j) == '-')) {
                ++j;
            }
            String string = key.text = j < len ? text.substring(j) : "";
            if (key.type.trim().length() == 0) {
                key = null;
            }
        } else {
            i = text.indexOf(45);
            if (i > 0) {
                key = new Key();
                key.type = "ENTRY";
                key.label = text.substring(0, i).trim().toUpperCase();
                for (int j = 0; j < key.label.length(); ++j) {
                    if (key.label.charAt(j) > ' ') continue;
                    return null;
                }
                key.text = text.substring(i + 1).trim();
            }
        }
        return key;
    }

    private int buildMainHelp(String opt) {
        String path = this.M.io.name("HLP", "", "", opt);
        ArrayList<Key> list3 = new ArrayList<Key>(16);
        this.fmhs = new TextFile(this.M, (Object)(path + mainFileName));
        this.fcnf = new TextFile(this.M, (Object)(path + configFileName));
        if (this.fcnf.find(-1)) {
            String text;
            this.M.info("File mainhelp.cnf found, generating mainhelp.hlp for " + opt);
            if (!this.fcnf.open(33)) {
                return -1;
            }
            if (!this.fmhs.open(34)) {
                return -1;
            }
            this.fmhs.writeln("~File MAINHELP");
            while ((text = this.fcnf.read()) != null) {
                this.fmhs.writeln(text);
                Key key = this.parseKey(text);
                if (key == null) continue;
                list3.add(key);
            }
            for (Key key : list3) {
                this.buildMainHelpFile(opt, key.label);
            }
        } else if (this.fmhs.find(-1)) {
            this.M.info("File mainhelp.cnf not found, using mainhelp.hlp for " + opt);
        } else {
            this.M.info("No mainhelp.cnf or mainhelp.hlp found for " + opt);
        }
        this.fmhs.close();
        this.fcnf.close();
        return 0;
    }

    private int buildMainHelpFile(String opt, String name) {
        String text;
        boolean header = true;
        boolean needOneLiner = false;
        String fn = this.M.io.name("HLP", name, "HLP", opt);
        TextFile tf = new TextFile(this.M, (Object)fn);
        if (!tf.open(32)) {
            return -1;
        }
        tf.setIncludeString("~Include");
        this.fmhs.writeln("~File " + name);
        this.fmhs.writeln("");
        while ((text = tf.read()) != null) {
            Key key = this.parseKey(text);
            if (key == null) {
                if (needOneLiner && text.length() > 0 && text.charAt(0) != ' ') {
                    int i = text.indexOf(". ");
                    if (i > 0) {
                        text = text.substring(0, i);
                    }
                    this.fmhs.writeln(text);
                    needOneLiner = false;
                }
            } else if (key.type.equals("MAIN")) {
                header = true;
                text = null;
            } else if (key.type.equals("SECTION") || key.type.equals("FUNCTION")) {
                if (needOneLiner) {
                    this.fmhs.writeln("unknown");
                }
                boolean bl = needOneLiner = key.text.length() == 0;
                if (needOneLiner) {
                    this.fmhs.write("  " + key.label + " - ");
                } else {
                    this.fmhs.writeln("  " + key.label + " - " + key.text);
                }
                header = false;
            } else {
                header = false;
            }
            if (!header || text == null) continue;
            this.fmhs.writeln(text);
        }
        this.fmhs.writeln("");
        tf.close();
        return 0;
    }

    private int buildHelp(String opt) {
        String homepage;
        String text;
        this.M.info("Building Help/Explain/Documents for " + opt);
        String path = this.M.io.name("HLP", "", "", opt);
        String optLC = opt.toLowerCase();
        ArrayList<Key> list3 = new ArrayList<Key>(16);
        this.fmhs = new TextFile(this.M, (Object)(path + mainFileName));
        if (this.fmhs.find(-1) && !this.fmhs.open(33)) {
            return -1;
        }
        String target = optLC + "_tree_index";
        this.fall = this.getHelpFile(target);
        this.writeHTMLHeader(this.fall, opt + " Top Help", opt + " Option Tree", null);
        TextFile fver = new TextFile(this.M, (Object)this.M.io.name(".", "version", "txt", opt));
        if (fver.open(33)) {
            this.fall.writeln("<p align='center'>");
            while ((text = fver.read()) != null) {
                if (text.startsWith("#")) continue;
                this.fall.writeln("  <code>" + text.replaceAll("  ", " &nbsp;") + "</code><br>");
            }
            this.fall.writeln("</p>");
            this.fall.writeln("");
            fver.close();
        }
        this.writeHTMLTableHeader(this.fall);
        this.writeHTMLBullet(this.fall, "CONCEPTS", optLC + "_hlp_all.html", "Operational Concepts - Help Tree");
        this.writeHTMLBullet(this.fall, "COMMANDS", optLC + "_exp_all.html", "Configured Commands - Explain Tree");
        this.writeHTMLBullet(this.fall, "DOCUMENTS", optLC + "_doc_all.html", "Supporting Documents - Docs Tree");
        text = "../api/nxm/" + optLC;
        if (CoreIO.fexists(this.jhdir + "../api/nxm/" + optLC + "/lib", true)) {
            this.writeHTMLBullet(this.fall, "LIBRARIES", text + "/lib/package-summary.html", "Libraries for Basic Functions");
        }
        if (CoreIO.fexists(this.jhdir + "../api/nxm/" + optLC + "/libg", true)) {
            this.writeHTMLBullet(this.fall, "GRAPHICS", text + "/libg/package-summary.html", "Libraries for Graphics Functions");
        }
        if (CoreIO.fexists(this.jhdir + "../api/nxm/" + optLC + "/libm", true)) {
            this.writeHTMLBullet(this.fall, "MATH", text + "/libm/package-summary.html", "Libraries for Mathematical Functions");
        }
        if (CoreIO.fexists(this.jhdir + "../api/nxm/" + optLC + "/lib", true)) {
            this.writeHTMLBullet(this.fall, "LIBRARIES", text + "/lib/package-summary.html", "Libraries for Basic Functions");
        }
        if (this.M.io.fexists(this.M.io.name("hlp", "release", "hlp", opt))) {
            this.writeHTMLBullet(this.fall, "RELEASE", optLC + "_hlp_release.html", "Release Notes for Current Version");
        }
        homepage = this.M.io.fexists(homepage = this.M.io.name("docs", "index", "html", opt)) ? "../../nxm/" + optLC + "/docs/index.html" : "";
        if ((homepage = this.MA.getCS("/HOMEPAGE", homepage)).length() > 0) {
            this.writeHTMLBullet(this.fall, "HOMEPAGE", homepage, "Option Tree Home Page");
        }
        this.writeHTMLTableFooter(this.fall);
        int ok = 0;
        TextFile fin = new TextFile(this.M, (Object)this.M.io.name(".", "copyright", "txt", opt));
        TextFile fout = new TextFile(this.M, (Object)(this.jhdir + optLC + "_copyright.txt"));
        if (fin.find(-1)) {
            ok += fin.copy(fout);
        }
        fin = new TextFile(this.M, (Object)this.M.io.name(".", "license", "txt", opt));
        fout = new TextFile(this.M, (Object)(this.jhdir + optLC + "_license.txt"));
        if (fin.find(-1)) {
            ok += fin.copy(fout);
        }
        if (ok > 0) {
            this.fall.writeln("<br><div style=\"text-align:center;\"><a href='" + optLC + "_copyright.txt'>Copyright</a>");
            this.fall.writeln(" / <a href='" + optLC + "_license.txt'>License</a></div>");
        }
        this.writeHTMLFooter(this.fall);
        this.fall.close();
        this.buildMainHelpFiles(opt, list3);
        target = optLC + "_hlp_all";
        this.fall = this.getHelpFile(target);
        this.writeHTMLHeader(this.fall, "All Concepts", opt + " Concept Index", null);
        this.writeHTMLTableHeader(this.fall);
        for (Key key : list3) {
            this.buildHelpFile(opt, key);
        }
        this.writeHTMLTableFooter(this.fall);
        this.writeHTMLFooter(this.fall);
        this.fall.close();
        target = optLC + "_exp_all";
        this.fall = this.getHelpFile(target);
        this.writeHTMLHeader(this.fall, "All Commands", opt + " Command Index", null);
        this.writeHTMLTableHeader(this.fall);
        this.writeHTMLCommandTableTitle(this.fall);
        for (int i = 0; i < this.M.dictionary.size; ++i) {
            Parser command = new Parser(this.M.dictionary.get(i));
            this.buildExplainFile(opt, command);
        }
        this.writeHTMLTableFooter(this.fall);
        this.writeHTMLFooter(this.fall);
        this.fall.close();
        target = optLC + "_doc_all";
        this.fall = this.getHelpFile(target);
        this.writeHTMLHeader(this.fall, "All Documents", opt + " Document Index", null);
        this.writeHTMLTableHeader(this.fall);
        path = this.M.io.name("HLP", "", "", opt);
        String[] files = this.M.io.listFiles(path, "*", "doc");
        String lpath = "../../nxm/" + optLC + "/hlp";
        if (!CoreIO.fexists(this.jhdir + lpath, true)) {
            lpath = null;
        }
        if (files != null) {
            this.writeHTMLBullet(this.fall, "|-- hlp/", lpath, "files under HLP area");
            Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
            for (String file : files) {
                this.buildDocumentFile(opt, path, file, lpath);
            }
        }
        path = this.M.io.name("DOCS", "", "", opt);
        files = this.M.io.listFiles(path, "*", "*");
        lpath = "../../nxm/" + optLC + "/docs";
        if (!CoreIO.fexists(this.jhdir + lpath, true)) {
            lpath = null;
        }
        if (files != null) {
            this.writeHTMLBullet(this.fall, "|-- docs/", lpath, "files under DOCS area");
            Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
            for (String file : files) {
                this.buildDocumentFile(opt, path, file, lpath);
            }
        }
        this.writeHTMLTableFooter(this.fall);
        this.writeHTMLFooter(this.fall);
        this.fall.close();
        this.fmhs.close();
        return 0;
    }

    private int buildMainHelpFiles(String opt, List<Key> list3) {
        String text;
        String path = this.M.io.name("HLP", "MAINHELP", "HLP", opt);
        this.fmhs = new TextFile(this.M, (Object)path);
        if (!this.fmhs.find(-1)) {
            return 0;
        }
        if (!this.fmhs.open(32)) {
            return -1;
        }
        String optLC = opt.toLowerCase();
        String target = optLC + "_hlp_main";
        TextFile fhtm = this.getHelpFile(target);
        this.writeHTMLHeader(fhtm, null, "Help: " + opt + "_MAIN", null);
        fhtm.writeln("<pre>");
        String section = null;
        this.fmhs.read();
        while ((text = this.fmhs.read()) != null) {
            Key key = this.parseKey(text);
            if (key == null) {
                fhtm.writeln(this.textToHtml(text, opt, "HLP"));
                continue;
            }
            if (key.type.equals("FILE")) {
                section = key.label;
                fhtm.writeln("</pre>");
                this.writeHTMLFooter(fhtm);
                fhtm.close();
                target = optLC + "_hlp_" + key.label.toLowerCase();
                fhtm = this.getHelpFile(target);
                this.writeHTMLHeader(fhtm, null, "Help: " + opt + "_" + key.label, key.text);
                fhtm.writeln("<pre>");
                continue;
            }
            if (!key.type.equals("ENTRY")) continue;
            if (section == null) {
                list3.add(key);
            }
            String starget = target + "_" + key.label.toLowerCase();
            this.writeHTMLBullet(fhtm, key.label, starget + ".html", key.text);
        }
        fhtm.writeln("</pre>");
        this.writeHTMLFooter(fhtm);
        fhtm.close();
        this.fmhs.close();
        return 0;
    }

    private int buildHelpFile(String opt, Key key) {
        String text;
        String starget = "";
        boolean section = false;
        String name = key.label;
        String optLC = opt.toLowerCase();
        String fn = this.M.io.name("HLP", name, "HLP", opt);
        TextFile tf = new TextFile(this.M, (Object)fn);
        if (!tf.open(32)) {
            return -1;
        }
        tf.setIncludeString("~Include");
        String target = optLC + "_hlp_" + name.toLowerCase();
        this.writeHTMLBullet(this.fall, name, target + ".html", key.text);
        TextFile fhtm = this.getHelpFile(target, false);
        while ((text = tf.read()) != null) {
            key = this.parseKey(text);
            if (key != null && !key.type.equals("ENTRY")) {
                if (key.type.equals("END")) {
                    text = null;
                } else if (key.type.equals("COMMENT")) {
                    text = null;
                } else if (key.type.equals("FILE")) {
                    text = "";
                } else if (key.type.equals("MAIN")) {
                    if (section) {
                        this.buildHelpFileCloseSection(fhtm, null);
                    }
                    section = false;
                } else if (key.type.equals("SUBSECTION")) {
                    fhtm.writeln("<a id=\"" + key.label + "\">");
                    text = key.label + key.text;
                } else {
                    if (section) {
                        this.buildHelpFileCloseSection(fhtm, null);
                    }
                    starget = target + "_" + key.label.toLowerCase();
                    fhtm = this.getHelpFile(starget);
                    if (key.text.length() == 0) {
                        key.text = this.getHelpKeyText(opt, name, key.label);
                    }
                    this.writeHTMLHeader(fhtm, null, "Help: " + opt + "_" + name + "_" + key.label, key.text);
                    fhtm.writeln("<pre>");
                    text = key.type.equals("FUNCTION") ? text.substring(1) : null;
                    section = true;
                }
            }
            if (!section || text == null) continue;
            fhtm.writeln(this.textToHtml(text, opt, "HLP"));
        }
        if (section) {
            this.buildHelpFileCloseSection(fhtm, null);
        }
        tf.close();
        return 0;
    }

    private void buildHelpFileCloseSection(TextFile fhtm, TextFile ftoc) {
        fhtm.writeln("</pre>");
        this.writeHTMLFooter(fhtm);
        fhtm.close();
    }

    private int buildExplainFile(String opt, Parser command) {
        String text;
        String option;
        String name = command.get(1);
        char support = command.get(2).charAt(0);
        int lname = name.indexOf(59);
        int lendName = name.indexOf(58);
        if (lendName < 0) {
            lendName = name.length();
        }
        if (!(option = name.substring(lname + 1, lendName)).equals(opt)) {
            return 0;
        }
        TextFile fexp = new TextFile(this.M, (Object)this.M.io.name("EXP", name = name.substring(0, lname), "exp", opt));
        if (!fexp.open(33)) {
            return 0;
        }
        fexp.setIncludeString("~Include");
        String optLC = opt.toLowerCase();
        String nameLC = name.toLowerCase();
        String target = optLC + "_exp_" + nameLC;
        TextFile fhtm = this.getHelpFile(target);
        ArrayList<String> fileText = new ArrayList<String>();
        while ((text = fexp.read()) != null) {
            fileText.add(text);
        }
        Key key = null;
        try {
            String txt;
            key = this.parseKey((String)fileText.get(0));
            String leadingSpace = StringUtil.padRight("", key.label.length());
            for (int i = 1; i < fileText.size() && (txt = (String)fileText.get(i)).startsWith(leadingSpace) && !txt.trim().startsWith("<") && !txt.trim().startsWith("["); ++i) {
                key.text = key.text + " " + txt.trim();
            }
            key.text = key.text.trim();
            if (key.text.length() > 1) {
                key.text = key.text.substring(0, 1).toUpperCase() + key.text.substring(1) + (key.text.endsWith(".") ? "" : ".");
            }
        }
        catch (Exception ex) {
            this.M.warning("Unable to build html from explain file for " + name + " command");
        }
        String fileTextString = "Unknown - invalid or missing explain file";
        if (key != null) {
            fileTextString = key.text;
        }
        this.writeHTMLHeader(fhtm, "Command Help -" + name, name, fileTextString);
        fhtm.writeln("<pre>");
        for (String str : fileText) {
            fhtm.writeln(this.textToHtml(str, opt, "EXP"));
        }
        String srcCodeName = null;
        String testMacroName = "test_" + nameLC;
        String className = null;
        String area = null;
        boolean noTest = false;
        switch (support) {
            case 'M': {
                area = "mcr";
                srcCodeName = nameLC + ".mm";
                break;
            }
            case 'H': {
                area = "host";
                srcCodeName = nameLC + ".for";
                break;
            }
            case 'I': {
                area = "intr";
                className = name.charAt(0) + nameLC.substring(1);
                break;
            }
            case 'P': {
                area = "prim";
                className = nameLC;
                break;
            }
            default: {
                area = "prim";
                className = nameLC;
            }
        }
        TextFile configFile = new TextFile(this.M, (Object)("nxm." + opt + ".test.test_config.tbl"));
        String testConfig = null;
        String optOfTestMacro = opt;
        if (configFile.exists()) {
            Table configTbl = new Table(configFile);
            testConfig = configTbl.getS(name);
        }
        if (testConfig != null) {
            int iSemicolon;
            if (testConfig.equals("NOTEST")) {
                noTest = true;
            } else if (!testConfig.equals("WEB") && !testConfig.equals("BROKEN") && (iSemicolon = (testMacroName = "test_" + testConfig.toLowerCase()).lastIndexOf(59)) > 0) {
                int optIndex = iSemicolon + 1;
                if (testMacroName.length() > optIndex) {
                    optOfTestMacro = testMacroName.substring(optIndex);
                }
                testMacroName = testMacroName.substring(0, iSemicolon);
            }
        }
        if (className != null) {
            srcCodeName = className + ".java";
        }
        String srcPath = this.relativeToDocDir(OptionTree.getOptPath(opt, area), srcCodeName);
        String testPath = OptionTree.getOptPath(optOfTestMacro, "test");
        String relativeToTestPath = this.relativeToDocDir(testPath, testMacroName + ".mm");
        String expPath = opt.toLowerCase() + "_exp_" + name.toLowerCase() + ".html";
        String docPath = null;
        if (className != null) {
            String dir = this.getJavadocDir(opt) + File.separator + "nxm" + File.separator + opt.toLowerCase() + File.separator + area;
            srcCodeName = className + ".java";
            docPath = this.relativeToDocDir(dir, className + ".html");
        }
        if (!noTest && !this.M.io.exists(testPath + testMacroName + ".mm")) {
            relativeToTestPath = null;
        }
        fhtm.writeln("</pre>");
        this.writeHTMLFooter(fhtm);
        this.fall.writeln("<tr>");
        this.fall.writeln("  <td><a href='" + expPath + "'>" + name + "</a></td>");
        this.fall.writeln("  <td>" + fileTextString + "</td>");
        this.fall.writeln("  <td align='center'>" + support + "</td>");
        if (docPath != null) {
            this.fall.writeln("  <td align='center'><a href='" + docPath + "'>doc</a></td>");
        } else {
            this.fall.writeln("  <td align='center'><a href='" + expPath + "'>doc</a></td>");
        }
        this.fall.writeln("  <td align='center'><a href='" + srcPath + "'>src</a></td>");
        if (noTest) {
            this.fall.writeln("  <td align='center'>n/a</td>");
        } else if (relativeToTestPath != null) {
            this.fall.writeln("  <td align='center'><a href='" + relativeToTestPath + "'>" + testMacroName + "</a></td>");
        } else {
            this.fall.writeln("  <td align='center'><i>missing</i></td>");
        }
        this.fall.writeln("</tr>");
        fhtm.close();
        fexp.close();
        return 0;
    }

    private String relativeToDocDir(String destDir, String fname) {
        File dest = new File(destDir);
        File docDir = new File(this.getHelpDir());
        String dir = FileUtil.getRelativeDir(docDir, dest);
        dir = dir.replace(File.separatorChar, '/');
        return dir + fname;
    }

    private int buildDocumentFile(String opt, String path, String dfname, String lpath) {
        FileName fn = new FileName(path + dfname, true);
        String name = fn.getRoot() + "." + fn.getExt();
        String url = fn.getFullName();
        if (lpath != null) {
            url = lpath + "/" + name;
        }
        this.writeHTMLBullet(this.fall, name, url, "document file");
        return 0;
    }

    private String getHelpTarget(String name) {
        String retValue = "sys_hlp_help_notfound";
        String section = null;
        String path = (String)this.M.results.get("OPT.PATH");
        String[] opts = StringUtil.cleanSplit(path, ",");
        for (int i = opts.length - 1; i >= 0; --i) {
            String text;
            String opt = opts[i];
            String fn = this.M.io.name("HLP", "MAINHELP", "HLP", opt);
            TextFile tf = new TextFile(this.M, (Object)fn);
            if (!tf.find(-1) || !tf.open(32)) continue;
            while ((text = tf.read()) != null) {
                Key key = this.parseKey(text);
                if (key == null) continue;
                if (key.type.equals("FILE")) {
                    section = key.label;
                    if (!name.equalsIgnoreCase(key.label)) continue;
                    retValue = opt + "_hlp_" + section;
                    continue;
                }
                if (!key.type.equals("ENTRY") || !name.equalsIgnoreCase(key.label)) continue;
                retValue = opt + "_hlp_" + section + "_" + key.label;
            }
            tf.close();
        }
        return retValue;
    }

    private String getHelpKeyText(String opt, String file, String name) {
        String text;
        boolean section = false;
        String fn = this.M.io.name("HLP", "MAINHELP", "HLP", opt);
        TextFile tf = new TextFile(this.M, (Object)fn);
        if (!tf.open(32)) {
            return "noMainHelp";
        }
        while ((text = tf.read()) != null) {
            Key key = this.parseKey(text);
            if (key == null) continue;
            if (key.type.equals("FILE")) {
                section = file.equalsIgnoreCase(key.label);
                continue;
            }
            if (!key.type.equals("ENTRY") || !section || !name.equalsIgnoreCase(key.label)) continue;
            return key.text;
        }
        tf.close();
        return "unknown";
    }

    private int buildMasterIndex() {
        String[] options = Shell.getKnownOptionTrees();
        this.fall = this.getHelpFile("index");
        this.writeHTMLHeader(this.fall, null, "NeXtMidas Master Help Index", "Configured Option Trees");
        this.fall.writeln("<div style=\"text-align:center;\"><a href='../search.html' target='_top'>Show Search Frame</a> &nbsp;         <a href='index.html' target='_top'>Hide Search Frame</a></div>");
        this.writeHTMLTableHeader(this.fall);
        for (String opt : options) {
            String fileName = opt.toLowerCase() + "_tree_index.html";
            this.writeHTMLBullet(this.fall, opt, fileName, "The " + opt + " option tree");
        }
        this.writeHTMLTableFooter(this.fall);
        String verClass = "4.1.4".substring(0, "4.1.4".lastIndexOf(46) + 1) + "X";
        String releaseFile = "ReleaseNotes_" + verClass.replace('.', '_') + ".html";
        String releaseName = "Release Notes " + verClass;
        this.fall.writeln("<h3 align='center'>General NeXtMidas Documentation</h3>");
        this.fall.writeln("<table border='1' cellpadding='2' cellspacing='0' style=\"margin-left:auto;margin-right:auto;\">");
        this.fall.writeln("  <tr>");
        this.fall.writeln("    <td><a href='../../nxm/sys/docs/" + releaseFile + "'>RN</a></td>");
        this.fall.writeln("    <td>" + releaseName + "</td>");
        this.fall.writeln("  </tr>");
        this.fall.writeln("  <tr>");
        this.fall.writeln("    <td><a href='../api/index.html'>API</a></td>");
        this.fall.writeln("    <td>Source Code Documentation</td>");
        this.fall.writeln("  </tr>");
        this.fall.writeln("  <tr>");
        this.fall.writeln("    <td><a href='../usersguide/index.html'>USER GUIDE</a></td>");
        this.fall.writeln("    <td><i>NeXtMidas User's Guide</i></td>");
        this.fall.writeln("  </tr>");
        this.fall.writeln("  <tr>");
        this.fall.writeln("    <td><a href='../training/index.html'>TRAINING</a></td>");
        this.fall.writeln("    <td><i>NeXtMidas Training Class</i></td>");
        this.fall.writeln("  </tr>");
        this.fall.writeln("  <tr>");
        this.fall.writeln("    <td><a href='../../nxm/sys/docs/InstallationGuide.html'>INSTALL</a></td>");
        this.fall.writeln("    <td><i>NeXtMidas Installation Guide</i></td>");
        this.fall.writeln("  </tr>");
        this.fall.writeln("</table>");
        this.writeHTMLFooter(this.fall);
        this.fall.close();
        return 0;
    }

    private TextFile getHelpFile(String targetName, boolean open) {
        TextFile tf = new TextFile(this.M, (Object)(this.jhdir + targetName + ".html"));
        if (open) {
            tf.open(12290);
        }
        return tf;
    }

    private TextFile getHelpFile(String target) {
        return this.getHelpFile(target, true);
    }

    private String textToHtml(String text, String opt, String area) {
        block2: {
            try {
                text = StringUtil.toHTML(text);
                text = this.translateSeeAlso(text, opt, area);
            }
            catch (Exception e) {
                this.M.warning("Help.textToHtml - Cannot translate the following text: " + text);
                if (!this.debug) break block2;
                this.M.warning(e);
            }
        }
        return text;
    }

    private String translateSeeAlso(String text, String opt, String area) {
        int k = text.length();
        int i = text.toUpperCase().indexOf("SEE");
        if (i < 0) {
            return text;
        }
        if (text.indexOf(58, i += 3) == i) {
            ++i;
        }
        while (text.indexOf(32, i) == i) {
            ++i;
        }
        if (text.toUpperCase().indexOf("ALSO", i) == i) {
            i += 4;
        }
        if (text.indexOf("the ", i) == i) {
            i += 4;
        }
        if (i >= k) {
            return text;
        }
        if (text.indexOf(58, i) == i) {
            ++i;
        }
        if (i >= k) {
            return text;
        }
        int j = text.indexOf(". ", i);
        if (j < i) {
            j = text.length();
        }
        while (text.charAt(j - 1) == ' ' || text.charAt(j - 1) == '.') {
            --j;
        }
        String stext = text.substring(0, i);
        k = j;
        while (i < k) {
            String[] tokens;
            while (i < k && text.charAt(i) == ' ') {
                ++i;
                stext = stext + " ";
            }
            if (i >= k) break;
            j = text.indexOf(44, i);
            if (j < 0 || j > k) {
                j = k;
            }
            if ((tokens = StringUtil.cleanSplit(text.substring(i, j), " ")).length >= 3 && tokens[2].equalsIgnoreCase("FILE")) {
                if (tokens[1].equalsIgnoreCase("EXPLAIN")) {
                    area = "EXP";
                } else if (tokens[1].equalsIgnoreCase("EXP")) {
                    area = "EXP";
                } else {
                    if (!tokens[1].equalsIgnoreCase("HELP")) break;
                    area = "HLP";
                }
                this.name = tokens[0];
                j = k = i + tokens[0].length() + tokens[1].length() + tokens[2].length() + 2;
            } else if (tokens.length >= 3 && tokens[1].equalsIgnoreCase("ON")) {
                if (tokens[0].equalsIgnoreCase("EXPLAIN")) {
                    area = "EXP";
                } else if (tokens[0].equalsIgnoreCase("EXP")) {
                    area = "EXP";
                } else {
                    if (!tokens[0].equalsIgnoreCase("HELP")) break;
                    area = "HLP";
                }
                this.name = tokens[2];
                j = k = i + tokens[0].length() + tokens[1].length() + tokens[2].length() + 2;
            } else if (tokens.length == 3) {
                if (tokens[1].equalsIgnoreCase("EXPLAIN") || tokens[1].equalsIgnoreCase("EXP")) {
                    area = "EXP";
                } else {
                    if (!tokens[1].equalsIgnoreCase("HELP")) break;
                    area = "HLP";
                }
                this.name = tokens[2];
                opt = tokens[0];
                j = k = i + tokens[0].length() + tokens[1].length() + tokens[2].length() + 2;
            } else if (tokens.length == 2) {
                if (tokens[0].equalsIgnoreCase("EXPLAIN") || tokens[0].equalsIgnoreCase("EXP")) {
                    area = "EXP";
                } else {
                    if (!tokens[0].equalsIgnoreCase("HELP")) break;
                    area = "HLP";
                }
                this.name = tokens[1];
                j = k = i + tokens[0].length() + tokens[1].length() + 1;
            } else {
                boolean resolved = false;
                if (tokens.length > 3) {
                    if (tokens[0].equalsIgnoreCase("EXPLAIN") || tokens[0].equalsIgnoreCase("EXP")) {
                        area = "EXP";
                        resolved = true;
                    } else if (tokens[0].equalsIgnoreCase("HELP")) {
                        area = "HLP";
                        resolved = true;
                    }
                    if (resolved) {
                        this.name = tokens[1];
                        j = k = i + tokens[0].length() + tokens[1].length() + 1;
                    }
                }
                if (tokens.length >= 1 && !resolved) {
                    this.name = tokens[0];
                    if (tokens.length > 1) {
                        j = k = i + tokens[0].length();
                    }
                    resolved = true;
                }
                if (!resolved) break;
            }
            this.name = this.name.trim();
            String[] parts = this.name.split("\\p{Punct}");
            int punct = 0;
            if (parts.length > 0 && parts[0].length() != this.name.length()) {
                int end = this.name.lastIndexOf(parts[parts.length - 1]) + parts[parts.length - 1].length();
                punct = this.name.length() - end;
                this.name = this.name.substring(0, end);
                j -= punct;
            }
            String[] subtokens = null;
            if (this.name.toUpperCase().indexOf("NXM.") >= 0) {
                subtokens = StringUtil.cleanSplit(text.substring(i, j), ".");
            }
            if (area.equalsIgnoreCase("EXPL")) {
                area = "EXP";
            }
            if (area.equalsIgnoreCase("HELP")) {
                area = "HLP";
            }
            if (area.equalsIgnoreCase("EXP") && VALID_COMMAND_REGEX.matcher(this.name).matches()) {
                Args args = Shell.parseCommand(this.M, this.name);
                this.name = args.name;
                opt = args.option;
            }
            String target = opt + "_" + area + "_" + this.name;
            if (area.equalsIgnoreCase("HLP")) {
                target = this.getHelpTarget(this.name);
            }
            if (subtokens != null) {
                if (subtokens.length > 3) {
                    String subExt = "html";
                    String subOpt = subtokens[1].toLowerCase();
                    String subArea = subtokens[2].toLowerCase();
                    String subName = subtokens[3];
                    String subPath = "../api/" + subOpt + "/nxm/";
                    if (subtokens.length > 4) {
                        subExt = subtokens[4];
                        subPath = "../../nxm/";
                    }
                    target = subPath + subOpt + "/" + subArea + "/" + subName + "." + subExt;
                } else {
                    this.M.warning("Unknown See Reference string = " + text.substring(i, j));
                }
            } else {
                target = target.toLowerCase() + ".html";
            }
            if (target.endsWith("_" + area.toLowerCase() + "_.html") || target.endsWith("notfound.html")) break;
            stext = stext + "<a href='" + target + "'>" + text.substring(i, j) + "</a>";
            if (j < k) {
                stext = stext + text.charAt(j++);
            }
            i = j;
        }
        if (i < text.length()) {
            stext = stext + text.substring(i);
        }
        return stext;
    }

    private void writeHTMLHeader(TextFile tf, String title, String head1, String head2) {
        if (title == null) {
            title = head1;
        }
        tf.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        tf.writeln("<html>");
        tf.writeln("<!-- ************************************************************************************* -->");
        tf.writeln("<!-- ** WARNING: This file is autogenerated any modifications to this file may be lost. ** -->");
        tf.writeln("<!-- ************************************************************************************* -->");
        tf.writeln("<head>");
        tf.writeln("  <title>" + title + "</title>");
        tf.writeln("  <link href='../../nxm/sys/docs/style.css' type='text/css' rel='stylesheet'>");
        tf.writeln("  <link href='../NXM.ico' rel='shortcut icon'>");
        tf.writeln("</head>");
        tf.writeln("<body><div>");
        if (head1 != null) {
            tf.writeln("<h2 align='center'>" + head1 + "</h2>");
        }
        if (head2 != null) {
            tf.writeln("<h3 align='center'>" + head2 + "</h3>");
        }
    }

    private void writeHTMLCommandTableTitle(TextFile tf) {
        tf.writeln("<tr>");
        tf.writeln("  <td>Command/Explain</td>");
        tf.writeln("  <td>Description</td>");
        tf.writeln("  <td align='center'>SUP</td>");
        tf.writeln("  <td align='center'>API</td>");
        tf.writeln("  <td align='center'>Source</td>");
        tf.writeln("  <td align='center'>Test Macro</td>");
        tf.writeln("</tr>");
    }

    private void writeHTMLTableHeader(TextFile tf) {
        tf.writeln("<table border='1' cellpadding='2' cellspacing='0' style=\"margin-left:auto;margin-right:auto;\">");
        this.inTable = true;
    }

    private void writeHTMLTableFooter(TextFile tf) {
        tf.writeln("</table>");
        this.inTable = false;
    }

    private void writeHTMLBullet(TextFile tf, String name, String ref, String text) {
        if (this.inTable) {
            tf.writeln("<tr><td><a href='" + ref + "'>" + name + "</a></td><td>" + text + "</td></tr>");
        } else {
            tf.writeln("  <a href='" + ref + "'>" + name + "</a> - " + text);
        }
    }

    private void writeHTMLFooter(TextFile tf) {
        tf.writeln("</div></body>");
        tf.writeln("</html>");
    }

    public String getHelpDir() {
        int delimLength = FileName.LOCAL_PATH_DELIM.length();
        return HELP_PATH.substring(0, HELP_PATH.length() - delimLength);
    }

    public String getJavadocDir(String opt) {
        return JAVADOC_PATH + opt.toLowerCase();
    }

    @LegacyMethod(value="use method in library Class: nxm.sys.lib.Shell.getKnownOptionTrees()}")
    public static String[] getKnownOptionTrees() {
        return Shell.getKnownOptionTrees();
    }

    private static class Key {
        String type;
        String file;
        String label;
        String text;
        String opt;

        private Key() {
        }

        public String toString() {
            return "Key: type=" + this.type + " file=" + this.file + " label=" + this.label + " text=" + this.text + " opt=" + this.opt;
        }
    }

    private static enum RunMode {
        INDEX,
        BUILD,
        GUI,
        LiteGUI,
        CLI,
        LegacyCLI;

    }
}

