/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.ArrayList;
import nxm.sys.inc.AsciiMap;
import nxm.sys.lib.Args;
import nxm.sys.lib.Generate;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;

public class Explain
extends Intrinsic
implements AsciiMap {
    private static final String[] RESERVED_SECTIONS = new String[]{"FUNCTIONS", "FUNCTION", "SEEALSO", "SEE ALSO", "MESSAGES", "EXAMPLES", "SWITCHES"};

    @Override
    public int process() {
        boolean dbg = this.MA.getState("/DEBUG", (this.M.debug & 0x20) != 0);
        this.verbose = this.MA.getState("/VERBOSE", false);
        String name = this.MA.getU("NAME");
        String sect = this.MA.getU("SECTION");
        int rowCount = this.MA.getL("/NR", -1);
        boolean generate = this.MA.getState("/GEN", false);
        boolean overWrite = this.MA.getState("/NEW", false);
        boolean check = this.MA.getState("/CHECK", false);
        boolean doWarn = this.MA.getState("/WARN", true);
        String outResName = this.MA.getU("/OUT", null);
        Args args = Shell.parseCommand(this.M, name);
        if (args.name.equals("")) {
            this.M.warning("'" + name + "' is not in the command dictionary. No explain file is available.");
            return 9;
        }
        String expName = args.name.startsWith("%") ? this.M.io.name("HOMEPATH", args.name.substring(1), "EXP", "AUX") : this.M.io.name("EXP", args.name, "EXP", args.option);
        if (generate) {
            String sourceName = this.getFullSourceName(args);
            int temp = Generate.genExplainFromSource(sourceName, args.name, expName, overWrite, doWarn);
            if (temp == -2) {
                this.M.warning(expName + " already exists, use /NEW to overwrite");
            } else if (temp == -1) {
                this.M.warning("Unable to overwrite existing file " + expName + " check permissions.");
            }
        } else if (check) {
            String sourceName = this.getFullSourceName(args);
            int numMissing = this.checkExplainFile(args.name, expName, sourceName, doWarn |= outResName == null, dbg);
            if (outResName != null) {
                this.MR.put(outResName, numMissing);
            }
        } else {
            if (sect != null && sect.equalsIgnoreCase("SeeAlso")) {
                sect = "See Also";
            }
            this.showExplainFile(name, expName, sect, rowCount);
        }
        return 9;
    }

    private void showExplainFile(String name, String fname, String section, int rowCount) {
        String text;
        int start = 0;
        int end = 0;
        String syntax = this.M.dictionary.getSyntax(name);
        TextFile file = new TextFile(this.M, (Object)fname);
        if (!file.open(33)) {
            this.M.println("No Explain file found for command: '" + name + "'");
            return;
        }
        ArrayList<String> fileLines = new ArrayList<String>();
        while ((text = file.read()) != null) {
            fileLines.add(text);
        }
        fileLines.add("");
        fileLines.add("Syntax: ");
        fileLines.add("  " + syntax);
        fileLines.add("");
        file.close();
        String[] lines = fileLines.toArray(StringUtil.EMPTY_STRING_ARRAY);
        if (section == null || section.length() == 0) {
            start = 0;
            end = lines.length - 1;
        } else {
            boolean inLine;
            String line;
            boolean inFunction = false;
            String funcName = section.trim().toUpperCase();
            if (!(section = funcName).endsWith(":")) {
                section = section + ":";
            }
            for (String reservedSection : RESERVED_SECTIONS) {
                if (!funcName.equals(reservedSection)) continue;
                funcName = null;
                break;
            }
            for (start = 0; start < lines.length; ++start) {
                line = lines[start].toUpperCase();
                if (inFunction) {
                    if (!(line.startsWith(" ") || line.startsWith("\t") || line.equals(""))) {
                        inFunction = false;
                        continue;
                    }
                    if (!line.startsWith(" ")) continue;
                    int index = (line = line.trim()).indexOf("<");
                    if (index > 0) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(":")) > 0) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf("-")) > 0) {
                        line = line.substring(0, index).trim();
                    }
                    if (!line.equals(funcName)) continue;
                    break;
                }
                if (line.startsWith(section)) break;
                if (!line.startsWith("FUNCTION:") && !line.startsWith("FUNCTIONS:")) continue;
                inFunction = funcName != null;
            }
            for (end = start + 1; end < lines.length; ++end) {
                line = lines[end].toUpperCase();
                if (line.startsWith(" ") || line.startsWith("\t") || line.equals("") || line.startsWith(section)) continue;
                --end;
                break;
            }
            boolean found = start < lines.length - 1;
            boolean bl = inLine = found && lines[start].trim().length() > section.length();
            if (found && (end > start || inLine)) {
                end = Math.min(end, lines.length - 1);
            } else {
                start = 0;
                end = lines.length - 1;
            }
        }
        int oldRowCount = this.M.terminal.getRows();
        this.M.terminal.setRows(rowCount);
        this.M.moreString(lines, start, end);
        this.M.terminal.setRows(oldRowCount);
    }

    public int checkExplainFile(String cmdName, String fullExpName, String fullSourceName, boolean doWarn, boolean dbg) {
        if (dbg) {
            System.out.println("EXPLAIN: Checking explain file " + fullExpName + " in source file " + fullSourceName + " warn? " + doWarn);
        }
        SourceParser sp = new SourceParser(fullSourceName, doWarn, dbg);
        TextFile tf = new TextFile(this.M, (Object)fullExpName);
        ArrayList<String> expList = new ArrayList<String>();
        if (tf.open(33)) {
            String line = tf.read();
            while (line != null) {
                expList.add(line);
                line = tf.read();
            }
        } else {
            this.M.warning("could not open file: " + fullExpName);
        }
        tf.close();
        if (dbg) {
            System.out.println("EXPLAIN CHECK: Number of lines in explain file = " + expList.size());
        }
        int missingParms = 0;
        String[] params = sp.getParameters();
        if (params != null) {
            for (int p = 0; p < params.length; ++p) {
                if (dbg) {
                    System.out.println("EXPLAIN CHECK: PARAMETER[" + p + "] " + params[p]);
                }
                String line = "";
                boolean foundReference = false;
                int l = 0;
                for (l = 0; l < expList.size() && !(foundReference = Explain.lineStartsWithParam(line = "" + (String)expList.get(l), params[p])); ++l) {
                }
                if (foundReference) {
                    if (!dbg) continue;
                    System.out.println("EXPLAIN CHECK: found reference to " + params[p] + " at line " + l + " in file");
                    continue;
                }
                if (doWarn) {
                    this.M.warning("Did not find reference to parameter " + params[p]);
                }
                ++missingParms;
            }
        } else if (this.verbose) {
            this.M.info("No command line parameters found in source");
        }
        int missingRxMsgs = 0;
        String[] rxMsgs = sp.getReceiveMessages();
        if (rxMsgs != null) {
            for (int p = 0; p < rxMsgs.length; ++p) {
                if (dbg) {
                    System.out.println("EXPLAIN CHECK: PARAMETER[" + p + "] " + rxMsgs[p]);
                }
                String line = "";
                boolean foundReference = false;
                int l = 0;
                for (l = 0; l < expList.size() && !(foundReference = (line = "" + (String)expList.get(l)).trim().toUpperCase().startsWith(rxMsgs[p].toUpperCase())); ++l) {
                }
                if (foundReference) {
                    if (!dbg) continue;
                    System.out.println("EXPLAIN CHECK: found reference to " + rxMsgs[p] + " at line " + l + " in file");
                    continue;
                }
                if (doWarn) {
                    this.M.warning("Did not find reference to RX message " + rxMsgs[p]);
                }
                ++missingRxMsgs;
            }
        } else if (this.verbose) {
            this.M.info("No receive messages found in source");
        }
        int missingSendMsgs = 0;
        String[] sendMsgs = sp.getSendMessages();
        if (sendMsgs != null) {
            for (int p = 0; p < sendMsgs.length; ++p) {
                if (dbg) {
                    System.out.println("EXPLAIN CHECK: PARAMETER[" + p + "] " + sendMsgs[p]);
                }
                String line = "";
                boolean foundReference = false;
                int l = 0;
                for (l = 0; l < expList.size() && !(foundReference = (line = "" + (String)expList.get(l)).trim().toUpperCase().startsWith(sendMsgs[p].toUpperCase())); ++l) {
                }
                if (foundReference) {
                    if (!dbg) continue;
                    System.out.println("EXPLAIN CHECK: found reference to " + sendMsgs[p] + " at line " + l + " in file");
                    continue;
                }
                if (doWarn) {
                    this.M.warning("Did not find reference to TX message " + sendMsgs[p]);
                }
                ++missingSendMsgs;
            }
        } else if (this.verbose) {
            this.M.info("No send messages found in source");
        }
        int missingSwitches = 0;
        String[] switches = sp.getSwitches();
        if (switches != null) {
            for (int s = 0; s < switches.length; ++s) {
                if (dbg) {
                    System.out.println("EXPLAIN CHECK: Switch[" + s + "] " + switches[s]);
                }
                String line = "";
                boolean foundReference = false;
                int l = 0;
                for (l = 0; l < expList.size() && !(foundReference = (line = "" + (String)expList.get(l)).trim().toUpperCase().startsWith(switches[s].toUpperCase())); ++l) {
                }
                if (foundReference) {
                    if (!dbg) continue;
                    System.out.println("EXPLAIN CHECK: found reference to " + switches[s] + " at line " + l + " in file");
                    continue;
                }
                if (doWarn) {
                    this.M.warning("Did not find reference to switch " + switches[s]);
                }
                ++missingSwitches;
            }
        } else if (this.verbose) {
            this.M.info("No SWITCHES found in source");
        }
        return missingParms + missingRxMsgs + missingSendMsgs + missingSwitches;
    }

    private static boolean lineStartsWithParam(String line, String parm) {
        String str;
        String cleanLine = Explain.cleanExpLine(line);
        boolean status = cleanLine.startsWith(str = "<" + parm + ">".toUpperCase());
        if (!status) {
            str = "[" + parm + "]".toUpperCase();
            status = cleanLine.startsWith(str);
        }
        if (!status && cleanLine.startsWith("[")) {
            int i1 = cleanLine.indexOf(44);
            int i2 = cleanLine.indexOf(93);
            if (i2 > 0 && i1 > 0 && i1 < i2) {
                Parser parser = new Parser(cleanLine.substring(1, i2).trim());
                for (int i = 1; !status && i <= parser.elements(); ++i) {
                    status = parm.equalsIgnoreCase(parser.get(i));
                }
            }
        }
        return status;
    }

    private static String cleanExpLine(String line) {
        return line.trim().toUpperCase();
    }

    private String getFullSourceName(Args args) {
        String fullSourceName = null;
        char support = args.support;
        String name = args.name;
        String option = args.option;
        if (support == 'M') {
            name = name.toLowerCase();
            fullSourceName = Macro.getFileName(this.M, name, option);
        } else if (support == 'P') {
            name = name.toLowerCase();
            fullSourceName = this.M.io.name("prim", name, "java", option);
        } else if (support == 'I') {
            name = name.substring(0, 1) + name.substring(1).toLowerCase();
            fullSourceName = this.M.io.name("intr", name, "java", option);
        } else if (support == 'N') {
            name = name.toLowerCase();
            fullSourceName = this.M.io.name("nat", name, "c", option);
        } else {
            this.M.warning("Command support " + support + " not supported");
        }
        return fullSourceName;
    }

    private class SourceParser {
        private String[] tags = StringUtil.EMPTY_STRING_ARRAY;
        private String[] rxMsgs = StringUtil.EMPTY_STRING_ARRAY;
        private String[] sendMsgs = StringUtil.EMPTY_STRING_ARRAY;
        private String[] switches = StringUtil.EMPTY_STRING_ARRAY;
        private boolean warn = true;
        private boolean dbg = false;

        public SourceParser(String fullSourceName) {
            this(fullSourceName, true, false);
        }

        public SourceParser(String fullSourceName, boolean warn, boolean dbg) {
            this.dbg = dbg;
            this.warn = warn;
            this.load(fullSourceName);
        }

        public String[] getParameters() {
            return this.tags;
        }

        public String[] getReceiveMessages() {
            return this.rxMsgs;
        }

        public String[] getSendMessages() {
            return this.sendMsgs;
        }

        public String[] getSwitches() {
            return this.switches;
        }

        private int load(String fullSourceName) {
            String switchesString = null;
            String tagsString = null;
            String rxMsgString = null;
            String sendMsgString = null;
            int status = -1;
            TextFile tfi = new TextFile(Explain.this.M, (Object)fullSourceName);
            if (tfi.open(33)) {
                String line;
                int linenum = 0;
                while ((line = tfi.read()) != null) {
                    String msgstr;
                    String tagName;
                    ++linenum;
                    int iMA = -1;
                    int iMSG = -1;
                    int iMSGSend = -1;
                    if (!line.trim().startsWith("//") && !line.trim().startsWith("/*")) {
                        iMA = this.paramIndex(line);
                        iMSG = this.rxMsgIndex(line);
                        iMSGSend = this.sendMsgIndex(line);
                    }
                    if (iMA >= 0) {
                        String mastring = line.substring(iMA);
                        tagName = Generate.getTagNameFromString(mastring);
                        if (tagName == null) {
                            if (this.warn) {
                                Explain.this.M.warning("could not find param tag in string '" + mastring + "'");
                                Explain.this.M.warning("Line " + linenum + ": " + line);
                            }
                        } else if (tagName.startsWith("/")) {
                            if (this.dbg) {
                                System.out.println("SP: Found switch '" + tagName + "'");
                            }
                            if (switchesString == null) {
                                switchesString = tagName;
                            } else if (switchesString.indexOf(tagName) < 0) {
                                switchesString = switchesString + "," + tagName;
                            }
                        } else {
                            if (this.dbg) {
                                System.out.println("SP: Found param '" + tagName + "'");
                            }
                            if (tagsString == null) {
                                tagsString = tagName;
                            } else if (tagsString.indexOf(tagName) < 0) {
                                tagsString = tagsString + "," + tagName;
                            }
                        }
                    }
                    if (iMSG >= 0) {
                        msgstr = line.substring(iMSG);
                        tagName = Generate.getTagNameFromString(msgstr);
                        if (tagName == null) {
                            if (this.warn) {
                                Explain.this.M.warning("WARN: could not find msg tag in string '" + msgstr + "'");
                                Explain.this.M.warning("Line " + linenum + ": " + line);
                            }
                        } else if (rxMsgString == null) {
                            if (this.dbg) {
                                System.out.println("SP: Found RX msg '" + tagName + "'");
                            }
                            rxMsgString = tagName;
                        } else {
                            if (this.dbg) {
                                System.out.println("SP: Found RX msg '" + tagName + "'");
                            }
                            if (rxMsgString.indexOf(tagName + ",") < 0) {
                                rxMsgString = rxMsgString + "," + tagName;
                            }
                        }
                    }
                    if (iMSGSend < 0) continue;
                    msgstr = line.substring(iMSGSend);
                    tagName = Generate.getTagNameFromString(msgstr);
                    if (tagName == null) {
                        if (!this.warn) continue;
                        Explain.this.M.warning("could not find msg tag in string '" + msgstr + "'");
                        Explain.this.M.warning("Line " + linenum + ": " + line);
                        continue;
                    }
                    if (sendMsgString == null) {
                        if (this.dbg) {
                            System.out.println("SP: Found TX msg '" + tagName + "'");
                        }
                        sendMsgString = tagName;
                        continue;
                    }
                    if (sendMsgString.indexOf(tagName + ",") >= 0) continue;
                    if (this.dbg) {
                        System.out.println("SP: Found TX msg '" + tagName + "'");
                    }
                    sendMsgString = sendMsgString + "," + tagName;
                }
                this.tags = StringUtil.cleanSplit(tagsString, ",");
                this.rxMsgs = StringUtil.cleanSplit(rxMsgString, ",");
                this.sendMsgs = StringUtil.cleanSplit(sendMsgString, ",");
                this.switches = StringUtil.cleanSplit(switchesString, ",");
                status = 1;
                tfi.close();
            }
            return status;
        }

        public int paramIndex(String line) {
            return line.indexOf("MA.");
        }

        public int rxMsgIndex(String line) {
            int index = line.indexOf("msg.name.equals(");
            if (index >= 0) {
                return index;
            }
            index = line.indexOf("msg.name.equals (");
            if (index >= 0) {
                return index;
            }
            index = line.indexOf("msg.name.startsWith(");
            if (index >= 0) {
                return index;
            }
            index = line.indexOf("msg.name.startsWith (");
            return index;
        }

        public int sendMsgIndex(String line) {
            int index = line.indexOf("MQ.put(");
            if (index >= 0) {
                return index;
            }
            index = line.indexOf("MQ.put (");
            return index;
        }
    }
}

