/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.BaseFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Midas;

public class Erase
extends Intrinsic {
    boolean all;
    boolean warn;
    boolean quiet;

    @Override
    public int process() {
        this.all = this.MA.getState("/ALL");
        this.warn = this.MA.getState("/WARN", true);
        this.quiet = this.MA.getState("/QUIET", !this.verbose);
        for (int i = 1; i <= this.MA.numberOf(); ++i) {
            BaseFile bf = this.MA.getFile(i);
            try {
                Erase.eraseFile(this.M, bf, !this.quiet, this.warn, this.all);
                continue;
            }
            catch (Exception e) {
                bf = this.MA.getBaseFile(i);
                Erase.eraseFile(this.M, bf, !this.quiet, this.warn, this.all);
            }
        }
        return 9;
    }

    public static void eraseFile(Midas M, BaseFile bf, boolean verbose, boolean warn, boolean force) {
        int status = bf.erase(force);
        if (status == 0) {
            if (warn) {
                M.warning("ERASE: Could not find URL=" + bf.getFileName().getFullName());
            }
        } else if (status == 64) {
            M.warning("Cannot erase protected URL=" + bf.getFileName().getFullName());
        } else if (bf instanceof DataFile) {
            DataFile df = (DataFile)bf;
            if ((status & 2) != 0 && warn) {
                M.warning("Trouble deleting URL=" + df.ioh.getURL());
            }
            if ((status & 8) != 0 && warn) {
                M.warning("Trouble deleting detach data URL=" + df.io.getURL());
            }
            if ((status & 0x20) != 0 && warn) {
                M.warning("Trouble deleting detach pipe header URL=" + df.hp.io.getURL());
            }
            if ((status & 1) != 0 && verbose) {
                M.info("Erased URL=" + df.ioh.getURL());
            }
            if ((status & 4) != 0 && verbose) {
                M.info("Erased URL=" + df.io.getURL());
            }
            if ((status & 0x10) != 0 && verbose) {
                M.info("Erased URL=" + df.hp.io.getURL());
            }
        } else if (status < 0) {
            if (warn) {
                M.warning("Trouble deleting URL=" + bf.getFileName().getFullName());
            }
        } else if (verbose) {
            M.info("Erased URL=" + bf.io.getURL());
            if (status > 1) {
                M.info("Erased URL=" + ((DataFile)bf).ioh.getURL());
            }
        }
    }
}

