/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.TextFile;

public class Configure
extends Intrinsic {
    private final int MIN_CMD_ABBREV = 2;
    private boolean warn = true;

    @Override
    public int process() {
        String func = this.MA.getU("FUNC");
        String opt = this.MA.getU("OPT", "SYS");
        this.warn = this.MA.getState("/WARN", true);
        if (func.indexOf("K") >= 0) {
            this.clear_commands();
        }
        if (!opt.equals("") && func.indexOf("C") >= 0) {
            this.add_commands(opt);
        }
        return 9;
    }

    private void clear_commands() {
        this.M.dictionary.clear();
        this.MR.put("OPT.PATH", (Object)"", 16);
        OptionTree.removeFromOptClasspath(this.MR.getTable("OPT.CLASSPATH"), "*");
    }

    private void add_commands(String option) {
        String line;
        String prevLine = null;
        String fname = this.M.io.name("CFG", "COMMANDS", "CNF", option);
        TextFile file = new TextFile(this.M, (Object)fname);
        boolean open = file.open(33);
        if (!open) {
            String cfg = this.M.io.name("CFG", "COMMANDS", "CFG", option);
            if (new BaseFile(this, (Object)cfg).exists()) {
                this.M.info("No NeXtMidas commands found for option [" + option + "], only X-Midas commands were found.");
            } else {
                String optCfgPath = OptionTree.getOptionPath(this.M, option, "cfg");
                if (optCfgPath == null) {
                    if (this.warn) {
                        this.M.warning("Unable to find option [" + option + "] on command.cnf. Assuming raw jar. ");
                    }
                } else {
                    cfg = FileName.addPathRootExt(optCfgPath, "commands", "cfg");
                    if (new BaseFile(this, (Object)cfg).exists()) {
                        this.M.info("No NeXtMidas commands found; only X-Midas commands were found for option [" + option + "]");
                    } else if (this.warn) {
                        this.M.warning("No file commands.cnf found for option [" + option + "] at path=[" + optCfgPath + "]. Assuming raw jar.");
                    }
                }
            }
        }
        while (open && (line = file.readProper()) != null) {
            Parser conf = new Parser(line);
            conf.clean();
            String name = conf.get(1);
            int ln = name.length();
            int la = name.indexOf("*");
            if (la > 0) {
                name = name.substring(0, la) + name.substring(la + 1);
            } else {
                if (name.length() > 2) {
                    this.M.deprecate("Two character default command abbreviations have been deprecated since 2.5.0.\nRun the UPDATE command on '" + name + "' to remove this warning");
                }
                la = Math.min(name.length(), 2);
            }
            name = name + ";" + option + ":" + la;
            line = conf.getAll();
            line = name + line.substring(ln);
            if (prevLine != null && line.charAt(0) < prevLine.charAt(0)) {
                this.M.warning("Command '" + line + "' appears out-of-order in " + option);
            }
            prevLine = line;
            line = this.checkArgCount(line);
            if (option.equals("SYS")) {
                this.M.dictionary.append(line);
                continue;
            }
            this.M.dictionary.insert(line);
        }
        file.close();
        this.M.dictionary.genAlpha();
        this.removeFromPath(option);
        this.addToPath(option);
    }

    private String checkArgCount(String line) {
        Parser parser = new Parser(line);
        String NARGS = parser.get(3);
        boolean xargs = false;
        if (NARGS.endsWith("+")) {
            NARGS = NARGS.substring(0, NARGS.length() - 1);
            xargs = true;
        }
        int numArgs = -1;
        try {
            numArgs = Integer.parseInt(NARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int argCount = 0;
        int arg = 1;
        while (arg + 3 <= parser.elements()) {
            if (!parser.get(arg + 3).startsWith("/")) {
                ++argCount;
            }
            ++arg;
        }
        if (!xargs && argCount > numArgs) {
            String[] nameParts = parser.get(1).split("[:;]");
            Shell.warning(String.format("The %s command takes in %d parameters, but %d defaults given. Please run 'UPDATE %s;%s' to correct this.", nameParts[0], numArgs, argCount, nameParts[0], nameParts[1]));
            String newLine = parser.get(1) + "," + parser.get(2) + "," + argCount + ",";
            for (int i = 4; i <= parser.elements(); ++i) {
                newLine = newLine + parser.get(i) + ",";
            }
            return newLine;
        }
        return line;
    }

    private void addToPath(String optName) {
        String s = this.MR.getS("OPT.PATH");
        s = s == null || s.length() == 0 ? optName : optName + "," + s;
        this.MR.put("OPT.PATH", (Object)s, 16);
        Shell.addOptToClasspath(optName, true);
    }

    private void removeFromPath(String optName) {
        String oc;
        String s = this.MR.getS("OPT.PATH");
        if (s == null || s.length() == 0) {
            return;
        }
        String sc = "," + s + ",";
        int i = sc.indexOf(oc = "," + optName + ",");
        if (i < 0) {
            return;
        }
        sc = i == 0 ? sc.substring(optName.length() + 1) : sc.substring(0, i) + sc.substring(i + optName.length() + 1);
        s = sc.equals(",") ? "" : sc.substring(1, sc.length() - 1);
        this.MR.put("OPT.PATH", (Object)s, 16);
    }
}

