/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.SSLUtilities;
import nxm.sys.lib.Table;

public class Checkauthorization
extends Intrinsic {
    private String userDN;
    private Table attrValueTbl;
    private String project;
    private String group;
    private String jsonResponse;
    private String jsonPathProps;
    private boolean allowPartialMatch;
    private boolean authorized;
    private boolean DEBUG = false;

    @Override
    public int open() {
        this.authorized = false;
        String label = this.MA.getU("LABEL", "AUTHORIZED");
        this.userDN = this.MA.getCS("USERDN");
        this.attrValueTbl = this.MA.getTable("USERATTR", null);
        if (this.DEBUG && this.attrValueTbl != null) {
            this.M.info("____Attributelogin: attrValueTbl: " + this.attrValueTbl.toString());
        }
        this.allowPartialMatch = this.MA.getState("/ALLOWPARTIAL", false);
        this.project = this.MA.getCS("PROJECT");
        this.group = this.MA.getCS("GROUP");
        this.jsonResponse = this.MA.getCS("JSONRESPONSE");
        this.jsonPathProps = this.MA.getCS("JSONPATHPROPS");
        if (!this.jsonResponse.isEmpty()) {
            if (!this.jsonPathProps.isEmpty()) {
                SSLUtilities.overideJsonKeyPaths(this.jsonPathProps);
            }
            this.authorized = SSLUtilities.verifyJsonHasAttributes(this.jsonResponse, this.attrValueTbl, this.allowPartialMatch);
        } else if (!this.project.isEmpty() || !this.group.isEmpty()) {
            if (this.project.isEmpty() || this.group.isEmpty()) {
                this.M.error("Attributelogin PROJ_GROUP: must specify project and group to authenticate against");
                return 9;
            }
            if (this.DEBUG) {
                this.M.info("____Attributelogin: group: " + this.group + " project: " + this.project);
            }
            if (this.DEBUG) {
                this.M.info("____Attributelogin userDN:" + this.userDN + " group:" + this.group + " project:" + this.project);
            }
            this.authorized = SSLUtilities.verifyGroupProject(this.userDN, this.group, this.project);
            if (this.DEBUG) {
                this.M.info("____Attributelogin: verified: " + this.authorized);
            }
        } else {
            CharSequence clientAttributes = SSLUtilities.getClientAttributes(this.userDN);
            if (this.DEBUG) {
                this.M.info("____Attributelogin: clientAttributes:" + clientAttributes);
            }
            boolean noAttributeFailures = true;
            if (this.attrValueTbl != null) {
                for (String attr : this.attrValueTbl) {
                    boolean thisAttributeIsValid = SSLUtilities.verifyUserAttribute(clientAttributes, attr, this.attrValueTbl.get(attr), this.allowPartialMatch);
                    if (this.DEBUG) {
                        this.M.info("____Attributelogin: attr:" + attr + " value:" + this.attrValueTbl.get(attr) + " valid:" + thisAttributeIsValid);
                    }
                    if (thisAttributeIsValid) continue;
                    noAttributeFailures = false;
                    break;
                }
                this.authorized = noAttributeFailures;
            } else {
                boolean bl = this.authorized = clientAttributes != null && clientAttributes.length() == 0;
            }
        }
        if (label != null) {
            this.MR.put(label, this.authorized);
        }
        return 9;
    }
}

