/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.File;
import java.util.ArrayList;
import nxm.sys.lib.Args;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Build
extends Intrinsic {
    public static final String MACRO_AREA = "mcr";
    public static final String INTR_AREA = "intr";
    public static final String PRIM_AREA = "prim";
    public static final String HOST_AREA = "host";
    public static final String TEST_AREA = "test";
    public static final String LIBC_AREA = "libc";
    public static final String LIBF_AREA = "libf";
    public static final String LIBM_AREA = "libm";
    private static final String[] ALL_SOURCE_EXTENSIONS = ".java|.c|.cc|.for|.flib|.clib|.cpplib".split("[|]");
    private boolean noNative;
    private boolean noHost;
    private boolean debug;
    private boolean generate;
    private boolean keepFiles;
    private boolean warn;
    private Table bldFlags;
    private int typesToBuild;

    @Override
    public int process() {
        String optPath = "," + (String)this.M.results.get("OPT.PATH") + ",";
        String name = this.MA.getCS("NAME");
        String area = this.MA.getCS("AREA");
        String opt = this.MA.getU("OPT", "SYS");
        if (name.equals("*")) {
            name = "ALL";
        }
        if (area.equals("*")) {
            area = "ALL";
        }
        boolean hostDef = area.equalsIgnoreCase(HOST_AREA) || optPath.indexOf(",XBC,") >= 0;
        this.noNative = !this.getArgs().getState("/DONATIVE", true);
        this.noHost = !this.getArgs().getState("/DOHOST", hostDef);
        this.generate = this.getArgs().getState("/DOGENERATE", true);
        this.bldFlags = this.getArgs().getTable("/BLDFLAGS", null);
        this.debug = this.MA.getState("/DEBUG");
        this.keepFiles = this.MA.getState("/KEEP");
        int defBuildTypes = 1 | (this.noNative ? 0 : 2) | (this.noHost ? 0 : 4);
        this.typesToBuild = this.MA.getOptionMask("/BLDTYPES", "Java,Native,Host", defBuildTypes);
        boolean defWarnNoFiles = (this.typesToBuild & 1) != 0;
        this.warn = this.MA.getState("/WARN", defWarnNoFiles);
        int filesCompiled = this.findAndBuild(opt, area, name);
        if (filesCompiled > 0) {
            if (!this.MA.getState("/NOEXIT", this.M.macro != null) && this.M.terminal.isExtCmdSupported() && !Shell.isOneShot()) {
                Foreign.runExternal(this.M, "");
            } else if (!this.M.terminal.isExtCmdSupported() || !Shell.isOneShot()) {
                this.M.warning("You must exit the shell to reload newly compiled files");
            }
        }
        return 9;
    }

    public int findAndBuild(String opt, String area, String name) {
        int numCompiled = 0;
        if (area.length() == 0 && !name.equalsIgnoreCase("ALL")) {
            String command = name;
            if (name.indexOf(46) > 0) {
                command = name.substring(0, name.indexOf(46));
            }
            Args targs = Shell.parseCommand(this.getContext(), command);
            switch (targs.support) {
                case 'M': {
                    area = MACRO_AREA;
                    name = targs.name;
                    break;
                }
                case 'I': {
                    area = INTR_AREA;
                    name = targs.name;
                    break;
                }
                case 'P': {
                    area = PRIM_AREA;
                    name = targs.name;
                    break;
                }
                case 'H': {
                    area = HOST_AREA;
                    name = targs.name;
                    break;
                }
                case 'O': {
                    break;
                }
                case 'U': {
                    break;
                }
                default: {
                    name = targs.name;
                }
            }
            opt = targs.option;
        }
        if (!name.equalsIgnoreCase("ALL")) {
            if (area.equals(MACRO_AREA) || area.equals(PRIM_AREA) || area.equals(HOST_AREA)) {
                name = name.toLowerCase();
            } else if (area.equals(INTR_AREA)) {
                name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
            }
        }
        if (name.endsWith(".mm")) {
            nxm.sys.lib.Build.compileMacro(opt, name);
            numCompiled = 1;
        } else {
            nxm.sys.lib.Build build = nxm.sys.lib.Build.newInstance(this.M, this.verbose, this.debug, this.keepFiles, this.bldFlags);
            if (area.equalsIgnoreCase("ALL")) {
                String libs_area_list = nxm.sys.lib.Build.getPropertyStatic(opt, "build.codeareas.libs");
                String other_area_list = nxm.sys.lib.Build.getPropertyStatic(opt, "build.codeareas.other");
                numCompiled = build.compile(opt, libs_area_list, this.typesToBuild);
                numCompiled += build.compile(opt, other_area_list, this.typesToBuild);
            } else if (name.equalsIgnoreCase("ALL")) {
                numCompiled = build.compile(opt, area, this.typesToBuild);
            } else if (nxm.sys.lib.Build.ALL_SOURCE_FILTER.accept(null, name)) {
                File file = new File(this.M.io.name(area, name, "", opt));
                numCompiled = build.compile(file, opt);
            } else {
                String path = this.M.io.name(area, "", "", opt);
                for (int i = 0; i < ALL_SOURCE_EXTENSIONS.length; ++i) {
                    String extension = ALL_SOURCE_EXTENSIONS[i].substring(1);
                    String[] fileNames = this.M.io.listFiles(path, name, extension);
                    if (fileNames == null || fileNames.length <= 0) continue;
                    ArrayList<File> filesList = new ArrayList<File>(fileNames.length);
                    for (int jj = 0; jj < fileNames.length; ++jj) {
                        File cppFile;
                        int indexPeriod;
                        String basefilename;
                        File forFile;
                        String filename = fileNames[jj];
                        boolean isC = ".c".equals(ALL_SOURCE_EXTENSIONS[i]);
                        boolean isCpp = ".cc".equals(ALL_SOURCE_EXTENSIONS[i]);
                        if ((isC || isCpp) && ((forFile = new File(path, (basefilename = (indexPeriod = filename.lastIndexOf(46)) > 0 ? filename.substring(0, indexPeriod) : filename) + ".for")).exists() || isC && (cppFile = new File(path, basefilename + ".cc")).exists())) continue;
                        filesList.add(new File(path, filename));
                    }
                    File[] files = filesList.toArray(new File[0]);
                    numCompiled += build.compile(files, opt, area);
                }
            }
            this.updateLastBuildResultsTable(build, opt);
        }
        if (numCompiled > 0) {
            String message = "Build " + numCompiled + " files for opt=" + opt;
            if (!area.equalsIgnoreCase("ALL")) {
                message = message + " area=" + area;
            }
            if (!name.equalsIgnoreCase("ALL")) {
                message = message + " name=" + name;
            }
            this.M.info(message);
        } else if (numCompiled == 0) {
            String fileTypes = Parser.mask2s("Java,Native,Host", this.typesToBuild);
            String msg = StringUtil.padRight("** BUILD: No " + fileTypes + " files found.", 51) + "**";
            if (this.warn) {
                this.M.warning("*****************************************************");
                this.M.warning(msg);
                this.M.warning("*****************************************************");
            } else if (this.verbose) {
                this.M.info("*****************************************************");
                this.M.info(msg);
                this.M.info("*****************************************************");
            }
        } else {
            this.M.warning("*****************************************************");
            this.M.warning("** BUILD FAILED: See error messages listed above.  **");
            this.M.warning("*****************************************************");
        }
        String resname = this.MA.getU("/COUNT");
        if (resname.length() > 0) {
            this.MR.put(resname, numCompiled);
        }
        return numCompiled;
    }

    private void updateLastBuildResultsTable(nxm.sys.lib.Build build, String opt) {
        if (this.M != null) {
            String optTableString = "{STATUS=" + this.M.getBuildStatus() + ",ERRORS=" + this.M.getBuildErrors() + "}";
            String fullBuildTable = "{" + opt + "=" + optTableString + "}";
            Results resTable = Shell.getCurrent().M.results;
            String buildResName = this.MA.getS("/BUILDRESULTS", "LASTBUILDRESULTS");
            if (resTable.containsKey(buildResName)) {
                Table envBuildTbl = (Table)resTable.get(buildResName);
                if (!envBuildTbl.isEmpty()) {
                    Table thisOpt = new Table(optTableString);
                    envBuildTbl.put(opt, (Object)thisOpt, 16);
                } else {
                    Table fullTable = new Table(fullBuildTable);
                    resTable.put(buildResName, (Object)fullTable, 16);
                }
            } else {
                Table fullTable = new Table(fullBuildTable);
                resTable.put(buildResName, (Object)fullTable, 16);
            }
        }
    }
}

