/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.regex.Pattern;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.XmUtil;

public class Auxiliary
extends Intrinsic {
    private static final Pattern AUX_REGEX = Pattern.compile("[A-Z0-9_]+");
    private boolean warn = true;

    @Override
    public int process() {
        int np = this.MA.numberOf();
        boolean list3 = this.MA.getState("/LIST");
        String waux = this.MA.getU("WRITE");
        String raux = this.MA.getU("READ");
        String save = this.MA.getU("/SAVE", "");
        String load = this.MA.getU("/LOAD", "");
        this.warn = this.MA.getZ("/WARN", true);
        if (this.MA.getState("/STORE") || save.length() > 0) {
            waux = this.MR.getS("AUX.WRITE");
            raux = this.MR.getS("AUX.READ");
            if (this.MA.getState("/STORE")) {
                this.MR.put("OLDAUXREAD", (Object)raux);
                this.MR.put("OLDAUXWRITE", (Object)waux);
            } else {
                this.MR.put(save, (Object)(waux + "," + raux));
            }
        } else if (this.MA.getState("/RESTORE") || load.length() > 0) {
            if (this.MA.getState("/RESTORE")) {
                waux = this.MR.getS("OLDAUXWRITE");
                raux = this.MR.getS("OLDAUXREAD");
            } else {
                String entry = this.MR.getS(load, "<error>");
                int index = entry.indexOf(44);
                if (index < 0) {
                    this.M.warning("Unable to load aux data from result " + load);
                    return 9;
                }
                waux = entry.substring(0, index);
                raux = entry.substring(index + 1);
            }
            this.MR.put("AUX.READ", (Object)raux);
            this.MR.put("AUX.WRITE", (Object)waux);
        } else if (waux.length() == 0 && raux.length() == 0 && np <= 2 || list3) {
            String[] keys;
            Table auxTable = this.MR.getTable("AUX");
            waux = auxTable.getS("WRITE");
            raux = auxTable.getS("READ");
            if (waux.startsWith("-")) {
                this.M.type("Write AUX     = " + waux + " (all output files will be written to " + waux + ")");
            } else {
                this.M.type("Write AUX     = " + waux + " (overwrite existing files, where applicable)");
            }
            this.M.type("Read AUX List = " + raux);
            this.M.type("");
            for (String key : keys = auxTable.getKeys()) {
                if (Auxiliary.isSpecialName(key)) continue;
                String path = this.M.io.getAuxPath(key, list3);
                if (list3) {
                    String alias = XmUtil.getAuxAlias(key);
                    if (alias == null) {
                        alias = "n/a";
                    }
                    this.M.type(StringUtil.padRight(key, 13) + " = " + StringUtil.padRight(path, 50) + " <XmAlias=" + alias + ">");
                    continue;
                }
                String type = IOResource.getTypeString(this.M, path);
                this.M.type(StringUtil.padRight(key, 13) + " = " + StringUtil.padRight(path, 50) + " <Type=" + type + ">");
            }
            this.checkAuxTable(auxTable);
        } else {
            Table auxTable = this.MR.getTable("AUX");
            boolean ok = true;
            if (waux.length() > 0) {
                waux = XmUtil.checkAuxName(waux);
                ok = this.checkAux(waux, true);
                this.MR.put("AUX.WRITE", (Object)waux);
            }
            if (raux.length() > 0) {
                raux = XmUtil.checkAuxName(raux);
                raux = this.setAux(raux, this.MR.getS("AUX.READ"), true);
                for (int i = 3; i <= np; ++i) {
                    String aux = XmUtil.checkAuxName(this.MA.getU(i));
                    raux = this.setAux(aux, raux, false);
                }
                this.MR.put("AUX.READ", (Object)raux);
            } else {
                raux = this.MR.getS("AUX.READ");
            }
            if (waux.startsWith("-")) {
                waux = waux.substring(1);
            }
            if (this.warn && ok && waux.length() > 0 && !this.findAux(waux, raux)) {
                this.M.warning("Write AUX '" + waux + "' not present on AUX.READ=\"" + raux + "\", this may prevent reading from newly-written files.");
            }
            this.checkAuxTable(auxTable);
        }
        return 9;
    }

    private String setAux(String arg, String raux, boolean isFirst) {
        int index = arg.lastIndexOf(124);
        if (index >= 0) {
            raux = this.setAux(arg.substring(0, index), raux, isFirst);
            arg = arg.substring(index + 1);
            isFirst = false;
        }
        if (arg.length() > 0) {
            boolean rem = arg.startsWith("-");
            boolean app = arg.startsWith("+");
            boolean pre = arg.endsWith("+");
            if (rem) {
                arg = arg.substring(1);
            } else if (app) {
                arg = arg.substring(1);
            } else if (pre) {
                arg = arg.substring(0, arg.length() - 1);
            }
            if (arg.equals("ALL")) {
                raux = rem ? this.setAux(this.allAux("-", ""), raux, isFirst) : (app ? this.setAux(this.allAux("+", ""), raux, isFirst) : (pre ? this.setAux(this.allAux("", "+"), raux, isFirst) : this.setAux(this.allAux("", ""), raux, isFirst)));
            } else if (rem) {
                raux = this.removeAux(arg, raux);
            } else if (app) {
                this.checkAux(arg);
                raux = this.appendAux(arg, raux);
            } else if (pre) {
                this.checkAux(arg);
                raux = this.prependAux(arg, raux);
            } else if (isFirst) {
                this.checkAux(arg);
                raux = arg;
            } else {
                this.checkAux(arg);
                raux = this.appendAux(arg, raux);
            }
        }
        return raux;
    }

    private boolean findAux(String aux, String list3) {
        String mlist = "|" + list3 + "|";
        return mlist.indexOf("|" + aux + "|") >= 0;
    }

    private String removeAux(String aux, String list3) {
        String mlist = "|" + list3 + "|";
        mlist = mlist.replaceAll("[|]" + aux + "[|]", "|");
        return mlist.substring(1, mlist.length() - 1);
    }

    private String appendAux(String aux, String list3) {
        return list3.length() == 0 ? aux : this.removeAux(aux, list3) + "|" + aux;
    }

    private String prependAux(String aux, String list3) {
        return list3.length() == 0 ? aux : aux + "|" + this.removeAux(aux, list3);
    }

    private boolean checkAux(String aux) {
        return this.checkAux(aux, false);
    }

    private boolean checkAux(String aux, boolean write) {
        boolean ok = false;
        if (aux.length() != 0) {
            if (aux.equals("READ") || aux.equals("WRITE") || aux.equals("ALL")) {
                this.M.error("AUX table entry " + aux + " is reserved for internal use, given \"" + aux + "\".");
            } else if (!write && aux.indexOf(45) >= 0) {
                this.M.error("Illegal character '-' in AUX table entry, given \"" + aux + "\".");
            } else if (aux.indexOf(43) >= 0) {
                this.M.error("Illegal character '+' in AUX table entry, given \"" + aux + "\".");
            } else if (aux.indexOf(124) >= 0) {
                this.M.error("Illegal character '|' in AUX table entry, given \"" + aux + "\".");
            } else if (this.warn) {
                if (aux.startsWith("-")) {
                    aux = aux.substring(1);
                }
                if (this.M.io.getAuxPath(aux) == null) {
                    if (write) {
                        this.M.warning("Unknown AUX table entry " + aux + " used for WRITE AUX, this may cause errors when writing files. Please add AUX table entry for " + aux + " or change WRITE AUX.");
                    } else {
                        this.M.warning("Unknown AUX table entry " + aux + " added to READ AUX, this may cause errors when reading files. Please add AUX table entry for " + aux + " or change READ AUX.");
                    }
                }
            } else {
                ok = true;
            }
        }
        return ok;
    }

    private boolean checkAuxTable(Keyable tbl) {
        String[] keys;
        boolean ok = true;
        for (String aux : keys = tbl.getKeys()) {
            if (Auxiliary.isSpecialName(aux)) continue;
            if (!AUX_REGEX.matcher(this.name).matches()) {
                ok = false;
                this.M.warning("Illegal AUX name 'AUX." + this.name + "'. AUX names can only contain letters (A-Z), numbers (0-9), and the underscore (_).");
                continue;
            }
            if (!this.name.equals("READ") && !this.name.equals("WRITE") && !this.name.equals("ALL")) continue;
            ok = false;
            this.M.warning("Can not use AUX." + this.name + " in NeXtMidas. The names 'READ', 'WRITE', and 'ALL' are reserved for use by the AUXILIARY command.");
        }
        return ok;
    }

    private static final boolean isSpecialName(String name) {
        return name.equals("READ") || name.equals("WRITE") || name.startsWith("_") && name.endsWith("_");
    }

    private String allAux(String prefix, String suffix) {
        StringBuilder list3 = new StringBuilder();
        Table auxes = this.MR.getTable("AUX");
        for (String key : auxes.getKeys()) {
            if (Auxiliary.isSpecialName(key) || key.equals("CWD") || key.equals("DAT") || key.equals("HOME") || key.equals("ALL") || auxes.getString(key) == null) continue;
            list3.append(prefix).append(key).append(suffix).append('|');
        }
        list3.append(prefix).append("DAT").append(suffix);
        return list3.toString();
    }
}

