/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.inc;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.ReflectUtil;

public interface MidasColor {
    public static final Color RED = MidasColor.getColor(80, 0, 0);
    public static final Color DARK_RED = MidasColor.getColor(55, 0, 0);
    public static final Color DARK_GOLDENROD = MidasColor.getColor(75, 50, 0);
    public static final Color YELLOW = MidasColor.getColor(80, 80, 0);
    public static final Color LIGHT_GREEN = MidasColor.getColor(25, 85, 0);
    public static final Color DARK_GREEN = MidasColor.getColor(0, 75, 0);
    public static final Color LIME_GREEN = MidasColor.getColor(20, 100, 20);
    public static final Color DARK_LIME_GREEN = MidasColor.getColor(0, 60, 0);
    public static final Color CYAN = MidasColor.getColor(0, 90, 75);
    public static final Color MODERATE_BLUE = MidasColor.getColor(25, 30, 75);
    public static final Color PEARLY_PURPLE = MidasColor.getColor(60, 30, 50);
    public static final Color DARK_GRAY = MidasColor.getColor(30, 30, 30);
    public static final Pattern WHITESPACE_REGEX = Pattern.compile("\\s");
    public static final String colorMapList = "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist";
    public static final int GRAYSCALE = 1;
    public static final int RAMP = 2;
    public static final int XRAMP = 3;
    public static final int WHEEL = 4;
    public static final int TERRAIN = 5;
    public static final int MULTI = 6;
    public static final int T5 = 7;
    public static final int MAPLINE = 8;
    public static final int GRID = 9;
    public static final int SPECTRUM = 10;
    public static final int XDATALIST = 11;
    public static final int MAXTYPE2D = 6;
    public static final int MAXTYPE = 9;
    @Deprecated
    public static final int C_CEP = 1;
    public static final int T5_INDEX_CEP = 1;
    @Deprecated
    public static final int C_HORIZON = 2;
    public static final int T5_INDEX_HORIZON = 2;
    @Deprecated
    public static final int C_TDOA = 3;
    public static final int T5_INDEX_TDOA = 3;
    @Deprecated
    public static final int C_FDOA = 4;
    public static final int T5_INDEX_FDOA = 4;
    @Deprecated
    public static final int C_T5000 = 5;
    public static final int T5_INDEX_TRACE5000 = 5;
    public static final byte T5_INDEX_GRAY = 1;
    public static final byte T5_INDEX_DARK_GREEN = 2;
    public static final byte T5_INDEX_RED = 3;
    public static final byte T5_INDEX_YELLOW = 4;
    public static final byte T5_INDEX_GREEN = 5;
    public static final Color T5_COLOR1_CEP = DARK_GRAY;
    public static final Color T5_COLOR2_HORIZON = DARK_LIME_GREEN;
    public static final Color T5_COLOR3_TDOA = RED;
    public static final Color T5_COLOR4_FDOA = YELLOW;
    public static final Color T5_COLOR5_TRACE5000 = LIME_GREEN;
    public static final int C_COASTLINE = 1;
    public static final int C_POLITICAL = 2;
    public static final int C_INTERPOL = 3;
    public static final int C_RIVER = 4;
    public static final int C_RAIL = 5;
    public static final int C_ROAD = 6;
    public static final int C_POL_OLD = 7;
    public static final int C_INTPOL_OLD = 8;
    public static final int C_AXIS = 1;
    public static final int C_GRID = 2;
    public static final int NOSHARE = 1;
    public static final int DEFCOLORS = 32;
    public static final byte[] CM_GRAY = new byte[]{0, 0, 0, 0, 100, 100, 100, 100};
    public static final byte[] CM_RAMP = new byte[]{0, 10, 0, 23, 18, 34, 0, 60, 36, 58, 20, 47, 55, 74, 20, 28, 72, 90, 43, 0, 87, 100, 72, 0, 100, 100, 100, 76};
    public static final byte[] CM_WHEEL = new byte[]{0, 100, 100, 0, 20, 0, 80, 40, 30, 0, 100, 100, 50, 10, 10, 90, 65, 100, 0, 100, 88, 100, 40, 0, 100, 100, 100, 0};
    public static final byte[] CM_TERRAIN = new byte[]{0, 0, 0, 40, 50, 0, 45, 55, 50, 0, 55, 55, 50, 0, 70, 20, 75, 75, 40, 25, 100, 100, 100, 95, 100, 100, 100, 100};
    public static final byte[] CM_MULTI = new byte[]{0, 0, 75, 0, 17, 0, 90, 90, 34, 0, 0, 90, 49, 90, 0, 90, 66, 90, 0, 0, 83, 90, 90, 0, 100, 95, 95, 95};
    public static final byte[] CM_XRAMP = new byte[]{0, 0, 0, 15, 10, 0, 0, 50, 31, 0, 65, 75, 50, 0, 85, 0, 70, 75, 80, 0, 83, 100, 60, 0, 100, 100, 0, 0};
    public static final byte[] CM_SPECTRUM = new byte[]{0, 0, 75, 0, 22, 0, 90, 90, 37, 0, 0, 85, 49, 90, 0, 85, 68, 90, 0, 0, 80, 90, 90, 0, 100, 95, 95, 95};
    public static final Color DEFAULT_COLOR = Color.white;
    public static final Method MCOLOR_TOSTRING = ReflectUtil.getMethodOfClass("nxm.sys.libg.MColor", "toString", Color.class);
    @InternalUseOnly
    public static final int OPAQUE = 255;

    public static Color getColor(int r, int g, int b) {
        Color color = new Color((float)r * 0.01f, (float)g * 0.01f, (float)b * 0.01f);
        return color;
    }

    public static Color getColor(Object obj) {
        return MidasColor.getColor(obj, DEFAULT_COLOR);
    }

    @InternalUseOnly
    public static Color getColor(Object obj, Color defaultColor) {
        Color colorForDefault;
        String str;
        Data data;
        if (obj instanceof Color) {
            return (Color)obj;
        }
        if (obj instanceof Data && !(data = (Data)obj).isString()) {
            int val;
            return new Color(val, ((val = Convert.o2l(data)) & 0xFF000000) != 0);
        }
        if (obj instanceof Number) {
            int val;
            return new Color(val, ((val = ((Number)obj).intValue()) & 0xFF000000) != 0);
        }
        Color color = null;
        String string = str = obj == null ? null : obj.toString();
        if (color == null) {
            color = MidasColor.getLegacyColor(str);
        }
        if (color == null) {
            color = NamedColors.getColor(str);
        }
        Color color2 = colorForDefault = defaultColor != null ? defaultColor : DEFAULT_COLOR;
        if (color == null) {
            color = Color.getColor(str, colorForDefault);
        }
        return color;
    }

    @InternalUseOnly
    public static Color getLegacyColor(String s) {
        Color color;
        if (s == null) {
            return null;
        }
        int intense = 0;
        if ((s = s.toUpperCase()).startsWith("INDEX:")) {
            int index = s.charAt(6) - 48;
            return MidasColor.getColorByIndex(index);
        }
        if (s.startsWith("#")) {
            s = "0X" + s.substring(1);
        }
        if (s.startsWith("0X")) {
            String alpha;
            String string = alpha = s.length() > 8 ? s.substring(2, 4) : "";
            if ("FF".equals(alpha)) {
                s = "0X" + s.substring(4);
            }
            int value = Convert.s2l(s);
            boolean hasAlpha = "00".equals(alpha) || (value & 0xFF000000) != 0;
            return new Color(value, hasAlpha);
        }
        if (s.startsWith("X") || s.startsWith("FF")) {
            throw new IllegalArgumentException("Specifying color using hex values must start with '#' or '0X', given: " + s);
        }
        while (s.startsWith("DARK")) {
            ++intense;
            s = s.substring(4);
        }
        while (s.startsWith("DEEP")) {
            intense += 3;
            s = s.substring(4);
        }
        while (s.startsWith("LIGHT")) {
            --intense;
            s = s.substring(5);
        }
        while (s.startsWith("BRIGHT")) {
            intense -= 3;
            s = s.substring(6);
        }
        if (s.equals("BLACK")) {
            color = Color.black;
        } else if (s.equals("BLUE")) {
            color = Color.blue;
        } else if (s.equals("CYAN")) {
            color = Color.cyan;
        } else if (s.equals("GRAY")) {
            color = Color.gray;
        } else if (s.equals("GREEN")) {
            color = Color.green;
        } else if (s.equals("MAGENTA")) {
            color = Color.magenta;
        } else if (s.equals("ORANGE")) {
            color = Color.orange;
        } else if (s.equals("PINK")) {
            color = Color.pink;
        } else if (s.equals("RED")) {
            color = Color.red;
        } else if (s.equals("WHITE")) {
            color = Color.white;
        } else if (s.equals("YELLOW")) {
            color = Color.yellow;
        } else if (s.equals("TEAL")) {
            color = new Color(0, 128, 128);
        } else if (s.equals("NAVY")) {
            color = new Color(0, 0, 128);
        } else if (s.equals("OLIVE")) {
            color = new Color(128, 128, 0);
        } else if (s.equals("DIMGRAY")) {
            color = new Color(105, 105, 105);
        } else if (s.equals("BROWN")) {
            color = new Color(165, 42, 42);
        } else if (s.equals("PURPLE")) {
            color = new Color(128, 0, 128);
        } else {
            return null;
        }
        while (intense > 0) {
            --intense;
            color = color.darker();
        }
        while (intense < 0) {
            ++intense;
            color = color.brighter();
        }
        return color;
    }

    public static Color getColorByIndex(int index) {
        Color color;
        switch (index) {
            case 1: {
                color = DARK_GREEN;
                break;
            }
            case 2: {
                color = MODERATE_BLUE;
                break;
            }
            case 3: {
                color = DARK_GOLDENROD;
                break;
            }
            case 4: {
                color = PEARLY_PURPLE;
                break;
            }
            case 5: {
                color = CYAN;
                break;
            }
            case 6: {
                color = LIGHT_GREEN;
                break;
            }
            case 7: {
                color = RED;
                break;
            }
            default: {
                color = DARK_RED;
            }
        }
        return color;
    }

    public static Color blend(Color color1, Color color2) {
        return MidasColor.blend(color1, color2, 0.5);
    }

    public static Color blend(Color color1, Color color2, double ratio) {
        float r = (float)ratio;
        float ir = 1.0f - r;
        float[] rgb1 = new float[4];
        float[] rgb2 = new float[4];
        color1.getComponents(rgb1);
        color2.getComponents(rgb2);
        Color color = new Color(rgb1[0] * r + rgb2[0] * ir, rgb1[1] * r + rgb2[1] * ir, rgb1[2] * r + rgb2[2] * ir, rgb1[3]);
        return color;
    }

    @InternalUseOnly
    public static Color getSpecialXMidasColor(int colNum) {
        Color color = Color.white;
        if (colNum < -6) {
            color = Color.white;
        } else {
            switch (colNum) {
                case -6: {
                    color = Color.white;
                    break;
                }
                case -5: {
                    color = Color.black;
                    break;
                }
                case -4: {
                    color = Color.gray;
                    break;
                }
                case -3: {
                    color = Color.green;
                    break;
                }
                case -2: {
                    color = Color.red;
                    break;
                }
                case -1: {
                    color = Color.yellow;
                    break;
                }
                case 0: {
                    color = new Color(128, 0, 128);
                    break;
                }
                default: {
                    color = Color.white;
                }
            }
        }
        return color;
    }

    public static Color invert(Color inColor) {
        if (inColor == null) {
            return null;
        }
        int argb = inColor.getRGB();
        byte alpha = (byte)(argb >> 24 & 0xFF);
        byte red = (byte)(argb >> 16 & 0xFF);
        byte green = (byte)(argb >> 8 & 0xFF);
        byte blue = (byte)(argb >> 0 & 0xFF);
        int invertedRGB = alpha << 24 | 255 - red << 16 | 255 - green << 8 | 255 - blue << 0;
        if (alpha == 255) {
            return new Color(invertedRGB);
        }
        return new Color(invertedRGB, true);
    }

    public static Color getColorMix(Color c0, Color c1, double mix) {
        if (mix > 1.0) {
            mix = 1.0;
        } else if (mix < 0.0) {
            mix = 0.0;
        }
        double mixi = 1.0 - mix;
        int r = (int)((double)c0.getRed() * mixi + (double)c1.getRed() * mix);
        int g = (int)((double)c0.getGreen() * mixi + (double)c1.getGreen() * mix);
        int b = (int)((double)c0.getBlue() * mixi + (double)c1.getBlue() * mix);
        return new Color(r, g, b);
    }

    public static String toString(Color color) {
        Optional<Object> result;
        if (MCOLOR_TOSTRING != null && (result = ReflectUtil.callMethod(null, MCOLOR_TOSTRING, new Object[]{color})).isPresent()) {
            return (String)result.get();
        }
        return color.toString();
    }

    public static double colorDifference(Color color1, Color color2) {
        int deltaRed = color1.getRed() - color2.getRed();
        int deltaRedSquared = deltaRed * deltaRed;
        int deltaGreen = color1.getGreen() - color2.getGreen();
        int deltaGreenSquared = deltaGreen * deltaGreen;
        int deltaB = color1.getBlue() - color2.getBlue();
        int deltaBlueSquared = deltaB * deltaB;
        double retVal = Math.sqrt(deltaRedSquared + deltaGreenSquared + deltaBlueSquared);
        return retVal / Math.sqrt(195075.0);
    }

    public static class NamedColors {
        private static final String[] SVG_COLOR_NAMES = new String[]{"00ffff", "cyan", "a9a9a9", "darkgrey", "2f4f4f", "darkslategrey", "696969", "dimgrey", "ffd700", "gold", "808080", "grey", "d3d3d3", "lightgrey", "778899", "lightslategrey", "cd853f", "peru", "ffc0cb", "pink", "dda0dd", "plum", "708090", "slategrey", "fffafa", "snow", "d2b48c", "tan"};
        private static final String[] NS_COLOR_NAMES = new String[]{"f0f8ff", "aliceblue", "faebd7", "antiquewhite", "00ffff", "aqua", "7fffd4", "aquamarine", "f0ffff", "azure", "f5f5dc", "beige", "ffe4c4", "bisque", "000000", "black", "ffebcd", "blanchedalmond", "0000ff", "blue", "8a2be2", "blueviolet", "a52a2a", "brown", "deb887", "burlywood", "5f9ea0", "cadetblue", "7fff00", "chartreuse", "d2691e", "chocolate", "ff7f50", "coral", "6495ed", "cornflowerblue", "fff8dc", "cornsilk", "dc143c", "crimson", "00008b", "darkblue", "008b8b", "darkcyan", "b8860b", "darkgoldenrod", "a9a9a9", "darkgray", "006400", "darkgreen", "bdb76b", "darkkhaki", "8b008b", "darkmagenta", "556b2f", "darkolivegreen", "ff8c00", "darkorange", "9932cc", "darkorchid", "8b0000", "darkred", "e9967a", "darksalmon", "8fbc8f", "darkseagreen", "483d8b", "darkslateblue", "2f4f4f", "darkslategray", "00ced1", "darkturquoise", "9400d3", "darkviolet", "ff1493", "deeppink", "00bfff", "deepskyblue", "696969", "dimgray", "1e90ff", "dodgerblue", "b22222", "firebrick", "fffaf0", "floralwhite", "228b22", "forestgreen", "ff00ff", "fuchsia", "dcdcdc", "gainsboro", "f8f8ff", "ghostwhite", "daa520", "goldenrod", "808080", "gray", "008000", "green", "adff2f", "greenyellow", "f0fff0", "honeydew", "ff69b4", "hotpink", "cd5c5c", "indianred", "4b0082", "indigo", "fffff0", "ivory", "f0e68c", "khaki", "e6e6fa", "lavender", "fff0f5", "lavenderblush", "7cfc00", "lawngreen", "fffacd", "lemonchiffon", "add8e6", "lightblue", "f08080", "lightcoral", "e0ffff", "lightcyan", "fafad2", "lightgoldenrodyellow", "90ee90", "lightgreen", "d3d3d3", "lightgrey", "ffb6c1", "lightpink", "ffa07a", "lightsalmon", "20b2aa", "lightseagreen", "87cefa", "lightskyblue", "778899", "lightslategray", "b0c4de", "lightsteelblue", "ffffe0", "lightyellow", "00ff00", "lime", "32cd32", "limegreen", "faf0e6", "linen", "ff00ff", "magenta", "800000", "maroon", "66cdaa", "mediumaquamarine", "0000cd", "mediumblue", "ba55d3", "mediumorchid", "9370db", "mediumpurple", "3cb371", "mediumseagreen", "7b68ee", "mediumslateblue", "00fa9a", "mediumspringgreen", "48d1cc", "mediumturquoise", "c71585", "mediumvioletred", "191970", "midnightblue", "f5fffa", "mintcream", "ffe4e1", "mistyrose", "ffe4b5", "moccasin", "ffdead", "navajowhite", "000080", "navy", "fdf5e6", "oldlace", "808000", "olive", "6b8e23", "olivedrab", "ffa500", "orange", "ff4500", "orangered", "da70d6", "orchid", "eee8aa", "palegoldenrod", "98fb98", "palegreen", "afeeee", "paleturquoise", "db7093", "palevioletred", "ffefd5", "papayawhip", "ffdab9", "peachpuff", "b0e0e6", "powderblue", "800080", "purple", "ff0000", "red", "bc8f8f", "rosybrown", "4169e1", "royalblue", "8b4513", "saddlebrown", "fa8072", "salmon", "f4a460", "sandybrown", "2e8b57", "seagreen", "fff5ee", "seashell", "a0522d", "sienna", "c0c0c0", "silver", "87ceeb", "skyblue", "6a5acd", "slateblue", "708090", "slategray", "00ff7f", "springgreen", "4682b4", "steelblue", "008080", "teal", "d8bfd8", "thistle", "ff6347", "tomato", "40e0d0", "turquoise", "ee82ee", "violet", "f5deb3", "wheat", "ffffff", "white", "f5f5f5", "whitesmoke", "ffff00", "yellow", "9acd32", "yellowgreen"};

        @Deprecated
        public NamedColors() {
        }

        public static Color getColor(String name) {
            return NamedColors.getSvgColor(name);
        }

        public static String getColorName(Color color) {
            return NamedColors.getSvgColorName(color);
        }

        public static Color getSvgColor(String name) {
            Color color = NamedColors.getNetscapeColor(name);
            if (color == null) {
                color = NamedColors.getColor(name, SVG_COLOR_NAMES);
            }
            return color;
        }

        public static String getSvgColorName(Color color) {
            String name = NamedColors.getColorName(color, NS_COLOR_NAMES);
            if (name == null) {
                name = NamedColors.getColorName(color, SVG_COLOR_NAMES);
            }
            return name;
        }

        public static Color getNetscapeColor(String name) {
            return NamedColors.getColor(name, NS_COLOR_NAMES);
        }

        public static String getNetscapeColorName(Color color) {
            return NamedColors.getColorName(color, NS_COLOR_NAMES);
        }

        protected static Color getColor(String name, String[] colorSet) {
            if (name == null) {
                return null;
            }
            name = name.toLowerCase();
            name = WHITESPACE_REGEX.matcher(name).replaceAll("");
            for (int i = 1; i < colorSet.length; i += 2) {
                if (!name.equals(colorSet[i])) continue;
                try {
                    int rgb = Integer.parseInt(colorSet[i - 1], 16);
                    return new Color(rgb);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Unable to initialize color: " + e);
                }
            }
            return null;
        }

        protected static String getColorName(Color color, String[] colorSet) {
            if (color == null) {
                return null;
            }
            int colorRGB = color.getRGB();
            try {
                for (int i = 0; i < colorSet.length; i += 2) {
                    int rgb = Integer.parseInt(colorSet[i], 16) + (colorSet[i].length() <= 6 ? -16777216 : 0);
                    if (colorRGB != rgb) continue;
                    return colorSet[i + 1];
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to initialize color: " + e);
            }
            return null;
        }
    }
}

